<?php

/**
 * Initialize VC custom icon pack
 */

add_action( 'vc_after_init', 'kd_custom_icon_pack' );
add_action( 'vc_enqueue_font_icon_element', 'kd_custom_icon_pack_enqueue' );

add_action( 'vc_backend_editor_enqueue_js_css', 'kd_vc_iconpicker_editor_jscss' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'kd_vc_iconpicker_editor_jscss' );

add_filter( 'vc_iconpicker-type-material', 'kd_custom_icon_pack_list_material' );


function kd_custom_icon_pack() {
	$param = WPBMap::getParam( 'vc_icon', 'type' );

	if( ! is_array($param))
	{
		return false;
	}

	$param['weight'] = 2;

	$param['value'] = array( 'Material icons' => 'materialicons' ) + $param['value'];

	vc_update_shortcode_param( 'vc_icon', $param );

	$attributes = array(
		'type'        => 'iconpicker',
		'heading'     => __('Icon', 'keydesign' ),
		'param_name'  => 'icon_material',
		'value'       => 'zmdi-3d-rotation',
		'weight'	  => 1,
		'settings'    => array(
			'emptyIcon'      => false,
			'type'           => 'material',
			'iconsPerPage'   => -1,
		),
		'dependency' => array(
			'element' => 'type',
			'value'   => 'materialicons',
		),
		'description' => 'Select icon from library.',
	);

	vc_add_param( 'vc_icon', $attributes );

	$param = WPBMap::getParam( 'vc_icon', 'color' );
	$param['std'] = 'black';

	vc_update_shortcode_param( 'vc_icon', $param );
}


function kd_custom_icon_pack_enqueue( $font ) {
	switch( $font ) {
		case "materialicons":
			wp_enqueue_style( 'material-design-iconic-font' );
			break;
	}
}


function kd_vc_iconpicker_editor_jscss() {
	wp_enqueue_style( 'material-design-iconic-font' );
}


function kd_custom_icon_pack_list_material( $icons ) {
	$material_icons = array(
    array( 'zmdi-3d-rotation' => '3d-rotation' ),
    array( 'zmdi-airplane-off' => 'airplane-off' ),
    array( 'zmdi-airplane' => 'airplane' ),
    array( 'zmdi-album' => 'album' ),
    array( 'zmdi-archive' => 'archive' ),
    array( 'zmdi-assignment-account' => 'assignment-account' ),
    array( 'zmdi-assignment-alert' => 'assignment-alert' ),
    array( 'zmdi-assignment-check' => 'assignment-check' ),
    array( 'zmdi-assignment-o' => 'assignment-o' ),
    array( 'zmdi-assignment-return' => 'assignment-return' ),
    array( 'zmdi-assignment-returned' => 'assignment-returned' ),
    array( 'zmdi-assignment' => 'assignment' ),
    array( 'zmdi-attachment-alt' => 'attachment-alt' ),
    array( 'zmdi-attachment' => 'attachment' ),
    array( 'zmdi-audio' => 'audio' ),
    array( 'zmdi-badge-check' => 'badge-check' ),
    array( 'zmdi-balance-wallet' => 'balance-wallet' ),
    array( 'zmdi-balance' => 'balance' ),
    array( 'zmdi-battery-alert' => 'battery-alert' ),
    array( 'zmdi-battery-flash' => 'battery-flash' ),
    array( 'zmdi-battery-unknown' => 'battery-unknown' ),
    array( 'zmdi-battery' => 'battery' ),
    array( 'zmdi-bike' => 'bike' ),
    array( 'zmdi-block-alt' => 'block-alt' ),
    array( 'zmdi-block' => 'block' ),
    array( 'zmdi-boat' => 'boat' ),
    array( 'zmdi-book-image' => 'book-image' ),
    array( 'zmdi-book' => 'book' ),
    array( 'zmdi-bookmark-outline' => 'bookmark-outline' ),
    array( 'zmdi-bookmark' => 'bookmark' ),
    array( 'zmdi-brush' => 'brush' ),
    array( 'zmdi-bug' => 'bug' ),
    array( 'zmdi-bus' => 'bus' ),
    array( 'zmdi-cake' => 'cake' ),
    array( 'zmdi-car-taxi' => 'car-taxi' ),
    array( 'zmdi-car-wash' => 'car-wash' ),
    array( 'zmdi-car' => 'car' ),
    array( 'zmdi-card-giftcard' => 'card-giftcard' ),
    array( 'zmdi-card-membership' => 'card-membership' ),
    array( 'zmdi-card-travel' => 'card-travel' ),
    array( 'zmdi-card' => 'card' ),
    array( 'zmdi-case-check' => 'case-check' ),
    array( 'zmdi-case-download' => 'case-download' ),
    array( 'zmdi-case-play' => 'case-play' ),
    array( 'zmdi-case' => 'case' ),
    array( 'zmdi-cast-connected' => 'cast-connected' ),
    array( 'zmdi-cast' => 'cast' ),
    array( 'zmdi-chart-donut' => 'chart-donut' ),
    array( 'zmdi-chart' => 'chart' ),
    array( 'zmdi-city-alt' => 'city-alt' ),
    array( 'zmdi-city' => 'city' ),
    array( 'zmdi-close-circle-o' => 'close-circle-o' ),
    array( 'zmdi-close-circle' => 'close-circle' ),
    array( 'zmdi-close' => 'close' ),
    array( 'zmdi-cocktail' => 'cocktail' ),
    array( 'zmdi-code-setting' => 'code-setting' ),
    array( 'zmdi-code-smartphone' => 'code-smartphone' ),
    array( 'zmdi-code' => 'code' ),
    array( 'zmdi-coffee' => 'coffee' ),
    array( 'zmdi-collection-bookmark' => 'collection-bookmark' ),
    array( 'zmdi-collection-case-play' => 'collection-case-play' ),
    array( 'zmdi-collection-folder-image' => 'collection-folder-image' ),
    array( 'zmdi-collection-image-o' => 'collection-image-o' ),
    array( 'zmdi-collection-image' => 'collection-image' ),
    array( 'zmdi-collection-item-1' => 'collection-item-1' ),
    array( 'zmdi-collection-item-2' => 'collection-item-2' ),
    array( 'zmdi-collection-item-3' => 'collection-item-3' ),
    array( 'zmdi-collection-item-4' => 'collection-item-4' ),
    array( 'zmdi-collection-item-5' => 'collection-item-5' ),
    array( 'zmdi-collection-item-6' => 'collection-item-6' ),
    array( 'zmdi-collection-item-7' => 'collection-item-7' ),
    array( 'zmdi-collection-item-8' => 'collection-item-8' ),
    array( 'zmdi-collection-item-9-plus' => 'collection-item-9-plus' ),
    array( 'zmdi-collection-item-9' => 'collection-item-9' ),
    array( 'zmdi-collection-item' => 'collection-item' ),
    array( 'zmdi-collection-music' => 'collection-music' ),
    array( 'zmdi-collection-pdf' => 'collection-pdf' ),
    array( 'zmdi-collection-plus' => 'collection-plus' ),
    array( 'zmdi-collection-speaker' => 'collection-speaker' ),
    array( 'zmdi-collection-text' => 'collection-text' ),
    array( 'zmdi-collection-video' => 'collection-video' ),
    array( 'zmdi-compass' => 'compass' ),
    array( 'zmdi-cutlery' => 'cutlery' ),
    array( 'zmdi-delete' => 'delete' ),
    array( 'zmdi-dialpad' => 'dialpad' ),
    array( 'zmdi-dns' => 'dns' ),
    array( 'zmdi-drink' => 'drink' ),
    array( 'zmdi-edit' => 'edit' ),
    array( 'zmdi-email-open' => 'email-open' ),
    array( 'zmdi-email' => 'email' ),
    array( 'zmdi-eye-off' => 'eye-off' ),
    array( 'zmdi-eye' => 'eye' ),
    array( 'zmdi-eyedropper' => 'eyedropper' ),
    array( 'zmdi-favorite-outline' => 'favorite-outline' ),
    array( 'zmdi-favorite' => 'favorite' ),
    array( 'zmdi-filter-list' => 'filter-list' ),
    array( 'zmdi-fire' => 'fire' ),
    array( 'zmdi-flag' => 'flag' ),
    array( 'zmdi-flare' => 'flare' ),
    array( 'zmdi-flash-auto' => 'flash-auto' ),
    array( 'zmdi-flash-off' => 'flash-off' ),
    array( 'zmdi-flash' => 'flash' ),
    array( 'zmdi-flip' => 'flip' ),
    array( 'zmdi-flower-alt' => 'flower-alt' ),
    array( 'zmdi-flower' => 'flower' ),
    array( 'zmdi-font' => 'font' ),
    array( 'zmdi-fullscreen-alt' => 'fullscreen-alt' ),
    array( 'zmdi-fullscreen-exit' => 'fullscreen-exit' ),
    array( 'zmdi-fullscreen' => 'fullscreen' ),
    array( 'zmdi-functions' => 'functions' ),
    array( 'zmdi-gas-station' => 'gas-station' ),
    array( 'zmdi-gesture' => 'gesture' ),
    array( 'zmdi-globe-alt' => 'globe-alt' ),
    array( 'zmdi-globe-lock' => 'globe-lock' ),
    array( 'zmdi-globe' => 'globe' ),
    array( 'zmdi-graduation-cap' => 'graduation-cap' ),
    array( 'zmdi-home' => 'home' ),
    array( 'zmdi-hospital-alt' => 'hospital-alt' ),
    array( 'zmdi-hospital' => 'hospital' ),
    array( 'zmdi-hotel' => 'hotel' ),
    array( 'zmdi-hourglass-alt' => 'hourglass-alt' ),
    array( 'zmdi-hourglass-outline' => 'hourglass-outline' ),
    array( 'zmdi-hourglass' => 'hourglass' ),
    array( 'zmdi-http' => 'http' ),
    array( 'zmdi-image-alt' => 'image-alt' ),
    array( 'zmdi-image-o' => 'image-o' ),
    array( 'zmdi-image' => 'image' ),
    array( 'zmdi-inbox' => 'inbox' ),
    array( 'zmdi-invert-colors-off' => 'invert-colors-off' ),
    array( 'zmdi-invert-colors' => 'invert-colors' ),
    array( 'zmdi-key' => 'key' ),
    array( 'zmdi-label-alt-outline' => 'label-alt-outline' ),
    array( 'zmdi-label-alt' => 'label-alt' ),
    array( 'zmdi-label-heart' => 'label-heart' ),
    array( 'zmdi-label' => 'label' ),
    array( 'zmdi-labels' => 'labels' ),
    array( 'zmdi-lamp' => 'lamp' ),
    array( 'zmdi-landscape' => 'landscape' ),
    array( 'zmdi-layers-off' => 'layers-off' ),
    array( 'zmdi-layers' => 'layers' ),
    array( 'zmdi-library' => 'library' ),
    array( 'zmdi-link' => 'link' ),
    array( 'zmdi-lock-open' => 'lock-open' ),
    array( 'zmdi-lock-outline' => 'lock-outline' ),
    array( 'zmdi-lock' => 'lock' ),
    array( 'zmdi-mail-reply-all' => 'mail-reply-all' ),
    array( 'zmdi-mail-reply' => 'mail-reply' ),
    array( 'zmdi-mail-send' => 'mail-send' ),
    array( 'zmdi-mall' => 'mall' ),
    array( 'zmdi-map' => 'map' ),
    array( 'zmdi-menu' => 'menu' ),
    array( 'zmdi-money-box' => 'money-box' ),
    array( 'zmdi-money-off' => 'money-off' ),
    array( 'zmdi-money' => 'money' ),
    array( 'zmdi-more-vert' => 'more-vert' ),
    array( 'zmdi-more' => 'more' ),
    array( 'zmdi-movie-alt' => 'movie-alt' ),
    array( 'zmdi-movie' => 'movie' ),
    array( 'zmdi-nature-people' => 'nature-people' ),
    array( 'zmdi-nature' => 'nature' ),
    array( 'zmdi-navigation' => 'navigation' ),
    array( 'zmdi-open-in-browser' => 'open-in-browser' ),
    array( 'zmdi-open-in-new' => 'open-in-new' ),
    array( 'zmdi-palette' => 'palette' ),
    array( 'zmdi-parking' => 'parking' ),
    array( 'zmdi-pin-account' => 'pin-account' ),
    array( 'zmdi-pin-assistant' => 'pin-assistant' ),
    array( 'zmdi-pin-drop' => 'pin-drop' ),
    array( 'zmdi-pin-help' => 'pin-help' ),
    array( 'zmdi-pin-off' => 'pin-off' ),
    array( 'zmdi-pin' => 'pin' ),
    array( 'zmdi-pizza' => 'pizza' ),
    array( 'zmdi-plaster' => 'plaster' ),
    array( 'zmdi-power-setting' => 'power-setting' ),
    array( 'zmdi-power' => 'power' ),
    array( 'zmdi-print' => 'print' ),
    array( 'zmdi-puzzle-piece' => 'puzzle-piece' ),
    array( 'zmdi-quote' => 'quote' ),
    array( 'zmdi-railway' => 'railway' ),
    array( 'zmdi-receipt' => 'receipt' ),
    array( 'zmdi-refresh-alt' => 'refresh-alt' ),
    array( 'zmdi-refresh-sync-alert' => 'refresh-sync-alert' ),
    array( 'zmdi-refresh-sync-off' => 'refresh-sync-off' ),
    array( 'zmdi-refresh-sync' => 'refresh-sync' ),
    array( 'zmdi-refresh' => 'refresh' ),
    array( 'zmdi-roller' => 'roller' ),
    array( 'zmdi-ruler' => 'ruler' ),
    array( 'zmdi-scissors' => 'scissors' ),
    array( 'zmdi-screen-rotation-lock' => 'screen-rotation-lock' ),
    array( 'zmdi-screen-rotation' => 'screen-rotation' ),
    array( 'zmdi-search-for' => 'search-for' ),
    array( 'zmdi-search-in-file' => 'search-in-file' ),
    array( 'zmdi-search-in-page' => 'search-in-page' ),
    array( 'zmdi-search-replace' => 'search-replace' ),
    array( 'zmdi-search' => 'search' ),
    array( 'zmdi-seat' => 'seat' ),
    array( 'zmdi-settings-square' => 'settings-square' ),
    array( 'zmdi-settings' => 'settings' ),
    array( 'zmdi-shield-check' => 'shield-check' ),
    array( 'zmdi-shield-security' => 'shield-security' ),
    array( 'zmdi-shopping-basket' => 'shopping-basket' ),
    array( 'zmdi-shopping-cart-plus' => 'shopping-cart-plus' ),
    array( 'zmdi-shopping-cart' => 'shopping-cart' ),
    array( 'zmdi-sign-in' => 'sign-in' ),
    array( 'zmdi-sort-amount-asc' => 'sort-amount-asc' ),
    array( 'zmdi-sort-amount-desc' => 'sort-amount-desc' ),
    array( 'zmdi-sort-asc' => 'sort-asc' ),
    array( 'zmdi-sort-desc' => 'sort-desc' ),
    array( 'zmdi-spellcheck' => 'spellcheck' ),
    array( 'zmdi-storage' => 'storage' ),
    array( 'zmdi-store-24' => 'store-24' ),
    array( 'zmdi-store' => 'store' ),
    array( 'zmdi-subway' => 'subway' ),
    array( 'zmdi-sun' => 'sun' ),
    array( 'zmdi-tab-unselected' => 'tab-unselected' ),
    array( 'zmdi-tab' => 'tab' ),
    array( 'zmdi-tag-close' => 'tag-close' ),
    array( 'zmdi-tag-more' => 'tag-more' ),
    array( 'zmdi-tag' => 'tag' ),
    array( 'zmdi-thumb-down' => 'thumb-down' ),
    array( 'zmdi-thumb-up-down' => 'thumb-up-down' ),
    array( 'zmdi-thumb-up' => 'thumb-up' ),
    array( 'zmdi-ticket-star' => 'ticket-star' ),
    array( 'zmdi-toll' => 'toll' ),
    array( 'zmdi-toys' => 'toys' ),
    array( 'zmdi-traffic' => 'traffic' ),
    array( 'zmdi-translate' => 'translate' ),
    array( 'zmdi-triangle-down' => 'triangle-down' ),
    array( 'zmdi-triangle-up' => 'triangle-up' ),
    array( 'zmdi-truck' => 'truck' ),
    array( 'zmdi-turning-sign' => 'turning-sign' ),
    array( 'zmdi-wallpaper' => 'wallpaper' ),
    array( 'zmdi-washing-machine' => 'washing-machine' ),
    array( 'zmdi-window-maximize' => 'window-maximize' ),
    array( 'zmdi-window-minimize' => 'window-minimize' ),
    array( 'zmdi-window-restore' => 'window-restore' ),
    array( 'zmdi-wrench' => 'wrench' ),
    array( 'zmdi-zoom-in' => 'zoom-in' ),
    array( 'zmdi-zoom-out' => 'zoom-out' ),
    array( 'zmdi-alert-circle-o' => 'alert-circle-o' ),
    array( 'zmdi-alert-circle' => 'alert-circle' ),
    array( 'zmdi-alert-octagon' => 'alert-octagon' ),
    array( 'zmdi-alert-polygon' => 'alert-polygon' ),
    array( 'zmdi-alert-triangle' => 'alert-triangle' ),
    array( 'zmdi-help-outline' => 'help-outline' ),
    array( 'zmdi-help' => 'help' ),
    array( 'zmdi-info-outline' => 'info-outline' ),
    array( 'zmdi-info' => 'info' ),
    array( 'zmdi-notifications-active' => 'notifications-active' ),
    array( 'zmdi-notifications-add' => 'notifications-add' ),
    array( 'zmdi-notifications-none' => 'notifications-none' ),
    array( 'zmdi-notifications-off' => 'notifications-off' ),
    array( 'zmdi-notifications-paused' => 'notifications-paused' ),
    array( 'zmdi-notifications' => 'notifications' ),
    array( 'zmdi-account-add' => 'account-add' ),
    array( 'zmdi-account-box-mail' => 'account-box-mail' ),
    array( 'zmdi-account-box-o' => 'account-box-o' ),
    array( 'zmdi-account-box-phone' => 'account-box-phone' ),
    array( 'zmdi-account-box' => 'account-box' ),
    array( 'zmdi-account-calendar' => 'account-calendar' ),
    array( 'zmdi-account-circle' => 'account-circle' ),
    array( 'zmdi-account-o' => 'account-o' ),
    array( 'zmdi-account' => 'account' ),
    array( 'zmdi-accounts-add' => 'accounts-add' ),
    array( 'zmdi-accounts-alt' => 'accounts-alt' ),
    array( 'zmdi-accounts-list-alt' => 'accounts-list-alt' ),
    array( 'zmdi-accounts-list' => 'accounts-list' ),
    array( 'zmdi-accounts-outline' => 'accounts-outline' ),
    array( 'zmdi-accounts' => 'accounts' ),
    array( 'zmdi-face' => 'face' ),
    array( 'zmdi-female' => 'female' ),
    array( 'zmdi-male-alt' => 'male-alt' ),
    array( 'zmdi-male-female' => 'male-female' ),
    array( 'zmdi-male' => 'male' ),
    array( 'zmdi-mood-bad' => 'mood-bad' ),
    array( 'zmdi-mood' => 'mood' ),
    array( 'zmdi-run' => 'run' ),
    array( 'zmdi-walk' => 'walk' ),
    array( 'zmdi-cloud-box' => 'cloud-box' ),
    array( 'zmdi-cloud-circle' => 'cloud-circle' ),
    array( 'zmdi-cloud-done' => 'cloud-done' ),
    array( 'zmdi-cloud-download' => 'cloud-download' ),
    array( 'zmdi-cloud-off' => 'cloud-off' ),
    array( 'zmdi-cloud-outline-alt' => 'cloud-outline-alt' ),
    array( 'zmdi-cloud-outline' => 'cloud-outline' ),
    array( 'zmdi-cloud-upload' => 'cloud-upload' ),
    array( 'zmdi-cloud' => 'cloud' ),
    array( 'zmdi-download' => 'download' ),
    array( 'zmdi-file-plus' => 'file-plus' ),
    array( 'zmdi-file-text' => 'file-text' ),
    array( 'zmdi-file' => 'file' ),
    array( 'zmdi-folder-outline' => 'folder-outline' ),
    array( 'zmdi-folder-person' => 'folder-person' ),
    array( 'zmdi-folder-star-alt' => 'folder-star-alt' ),
    array( 'zmdi-folder-star' => 'folder-star' ),
    array( 'zmdi-folder' => 'folder' ),
    array( 'zmdi-gif' => 'gif' ),
    array( 'zmdi-upload' => 'upload' ),
    array( 'zmdi-border-all' => 'border-all' ),
    array( 'zmdi-border-bottom' => 'border-bottom' ),
    array( 'zmdi-border-clear' => 'border-clear' ),
    array( 'zmdi-border-color' => 'border-color' ),
    array( 'zmdi-border-horizontal' => 'border-horizontal' ),
    array( 'zmdi-border-inner' => 'border-inner' ),
    array( 'zmdi-border-left' => 'border-left' ),
    array( 'zmdi-border-outer' => 'border-outer' ),
    array( 'zmdi-border-right' => 'border-right' ),
    array( 'zmdi-border-style' => 'border-style' ),
    array( 'zmdi-border-top' => 'border-top' ),
    array( 'zmdi-border-vertical' => 'border-vertical' ),
    array( 'zmdi-copy' => 'copy' ),
    array( 'zmdi-crop' => 'crop' ),
    array( 'zmdi-format-align-center' => 'format-align-center' ),
    array( 'zmdi-format-align-justify' => 'format-align-justify' ),
    array( 'zmdi-format-align-left' => 'format-align-left' ),
    array( 'zmdi-format-align-right' => 'format-align-right' ),
    array( 'zmdi-format-bold' => 'format-bold' ),
    array( 'zmdi-format-clear-all' => 'format-clear-all' ),
    array( 'zmdi-format-clear' => 'format-clear' ),
    array( 'zmdi-format-color-fill' => 'format-color-fill' ),
    array( 'zmdi-format-color-reset' => 'format-color-reset' ),
    array( 'zmdi-format-color-text' => 'format-color-text' ),
    array( 'zmdi-format-indent-decrease' => 'format-indent-decrease' ),
    array( 'zmdi-format-indent-increase' => 'format-indent-increase' ),
    array( 'zmdi-format-italic' => 'format-italic' ),
    array( 'zmdi-format-line-spacing' => 'format-line-spacing' ),
    array( 'zmdi-format-list-bulleted' => 'format-list-bulleted' ),
    array( 'zmdi-format-list-numbered' => 'format-list-numbered' ),
    array( 'zmdi-format-ltr' => 'format-ltr' ),
    array( 'zmdi-format-rtl' => 'format-rtl' ),
    array( 'zmdi-format-size' => 'format-size' ),
    array( 'zmdi-format-strikethrough-s' => 'format-strikethrough-s' ),
    array( 'zmdi-format-strikethrough' => 'format-strikethrough' ),
    array( 'zmdi-format-subject' => 'format-subject' ),
    array( 'zmdi-format-underlined' => 'format-underlined' ),
    array( 'zmdi-format-valign-bottom' => 'format-valign-bottom' ),
    array( 'zmdi-format-valign-center' => 'format-valign-center' ),
    array( 'zmdi-format-valign-top' => 'format-valign-top' ),
    array( 'zmdi-redo' => 'redo' ),
    array( 'zmdi-select-all' => 'select-all' ),
    array( 'zmdi-space-bar' => 'space-bar' ),
    array( 'zmdi-text-format' => 'text-format' ),
    array( 'zmdi-transform' => 'transform' ),
    array( 'zmdi-undo' => 'undo' ),
    array( 'zmdi-wrap-text' => 'wrap-text' ),
    array( 'zmdi-comment-alert' => 'comment-alert' ),
    array( 'zmdi-comment-alt-text' => 'comment-alt-text' ),
    array( 'zmdi-comment-alt' => 'comment-alt' ),
    array( 'zmdi-comment-edit' => 'comment-edit' ),
    array( 'zmdi-comment-image' => 'comment-image' ),
    array( 'zmdi-comment-list' => 'comment-list' ),
    array( 'zmdi-comment-more' => 'comment-more' ),
    array( 'zmdi-comment-outline' => 'comment-outline' ),
    array( 'zmdi-comment-text-alt' => 'comment-text-alt' ),
    array( 'zmdi-comment-text' => 'comment-text' ),
    array( 'zmdi-comment-video' => 'comment-video' ),
    array( 'zmdi-comment' => 'comment' ),
    array( 'zmdi-comments' => 'comments' ),
    array( 'zmdi-check-all' => 'check-all' ),
    array( 'zmdi-check-circle-u' => 'check-circle-u' ),
    array( 'zmdi-check-circle' => 'check-circle' ),
    array( 'zmdi-check-square' => 'check-square' ),
    array( 'zmdi-check' => 'check' ),
    array( 'zmdi-circle-o' => 'circle-o' ),
    array( 'zmdi-circle' => 'circle' ),
    array( 'zmdi-dot-circle-alt' => 'dot-circle-alt' ),
    array( 'zmdi-dot-circle' => 'dot-circle' ),
    array( 'zmdi-minus-circle-outline' => 'minus-circle-outline' ),
    array( 'zmdi-minus-circle' => 'minus-circle' ),
    array( 'zmdi-minus-square' => 'minus-square' ),
    array( 'zmdi-minus' => 'minus' ),
    array( 'zmdi-plus-circle-o-duplicate' => 'plus-circle-o-duplicate' ),
    array( 'zmdi-plus-circle-o' => 'plus-circle-o' ),
    array( 'zmdi-plus-circle' => 'plus-circle' ),
    array( 'zmdi-plus-square' => 'plus-square' ),
    array( 'zmdi-plus' => 'plus' ),
    array( 'zmdi-square-o' => 'square-o' ),
    array( 'zmdi-star-circle' => 'star-circle' ),
    array( 'zmdi-star-half' => 'star-half' ),
    array( 'zmdi-star-outline' => 'star-outline' ),
    array( 'zmdi-star' => 'star' ),
    array( 'zmdi-bluetooth-connected' => 'bluetooth-connected' ),
    array( 'zmdi-bluetooth-off' => 'bluetooth-off' ),
    array( 'zmdi-bluetooth-search' => 'bluetooth-search' ),
    array( 'zmdi-bluetooth-setting' => 'bluetooth-setting' ),
    array( 'zmdi-bluetooth' => 'bluetooth' ),
    array( 'zmdi-camera-add' => 'camera-add' ),
    array( 'zmdi-camera-alt' => 'camera-alt' ),
    array( 'zmdi-camera-bw' => 'camera-bw' ),
    array( 'zmdi-camera-front' => 'camera-front' ),
    array( 'zmdi-camera-mic' => 'camera-mic' ),
    array( 'zmdi-camera-party-mode' => 'camera-party-mode' ),
    array( 'zmdi-camera-rear' => 'camera-rear' ),
    array( 'zmdi-camera-roll' => 'camera-roll' ),
    array( 'zmdi-camera-switch' => 'camera-switch' ),
    array( 'zmdi-camera' => 'camera' ),
    array( 'zmdi-card-alert' => 'card-alert' ),
    array( 'zmdi-card-off' => 'card-off' ),
    array( 'zmdi-card-sd' => 'card-sd' ),
    array( 'zmdi-card-sim' => 'card-sim' ),
    array( 'zmdi-desktop-mac' => 'desktop-mac' ),
    array( 'zmdi-desktop-windows' => 'desktop-windows' ),
    array( 'zmdi-device-hub' => 'device-hub' ),
    array( 'zmdi-devices-off' => 'devices-off' ),
    array( 'zmdi-devices' => 'devices' ),
    array( 'zmdi-dock' => 'dock' ),
    array( 'zmdi-floppy' => 'floppy' ),
    array( 'zmdi-gamepad' => 'gamepad' ),
    array( 'zmdi-gps-dot' => 'gps-dot' ),
    array( 'zmdi-gps-off' => 'gps-off' ),
    array( 'zmdi-gps' => 'gps' ),
    array( 'zmdi-headset-mic' => 'headset-mic' ),
    array( 'zmdi-headset' => 'headset' ),
    array( 'zmdi-input-antenna' => 'input-antenna' ),
    array( 'zmdi-input-composite' => 'input-composite' ),
    array( 'zmdi-input-hdmi' => 'input-hdmi' ),
    array( 'zmdi-input-power' => 'input-power' ),
    array( 'zmdi-input-svideo' => 'input-svideo' ),
    array( 'zmdi-keyboard-hide' => 'keyboard-hide' ),
    array( 'zmdi-keyboard' => 'keyboard' ),
    array( 'zmdi-laptop-chromebook' => 'laptop-chromebook' ),
    array( 'zmdi-laptop-mac' => 'laptop-mac' ),
    array( 'zmdi-laptop' => 'laptop' ),
    array( 'zmdi-mic-off' => 'mic-off' ),
    array( 'zmdi-mic-outline' => 'mic-outline' ),
    array( 'zmdi-mic-setting' => 'mic-setting' ),
    array( 'zmdi-mic' => 'mic' ),
    array( 'zmdi-mouse' => 'mouse' ),
    array( 'zmdi-network-alert' => 'network-alert' ),
    array( 'zmdi-network-locked' => 'network-locked' ),
    array( 'zmdi-network-off' => 'network-off' ),
    array( 'zmdi-network-outline' => 'network-outline' ),
    array( 'zmdi-network-setting' => 'network-setting' ),
    array( 'zmdi-network' => 'network' ),
    array( 'zmdi-phone-bluetooth' => 'phone-bluetooth' ),
    array( 'zmdi-phone-end' => 'phone-end' ),
    array( 'zmdi-phone-forwarded' => 'phone-forwarded' ),
    array( 'zmdi-phone-in-talk' => 'phone-in-talk' ),
    array( 'zmdi-phone-locked' => 'phone-locked' ),
    array( 'zmdi-phone-missed' => 'phone-missed' ),
    array( 'zmdi-phone-msg' => 'phone-msg' ),
    array( 'zmdi-phone-paused' => 'phone-paused' ),
    array( 'zmdi-phone-ring' => 'phone-ring' ),
    array( 'zmdi-phone-setting' => 'phone-setting' ),
    array( 'zmdi-phone-sip' => 'phone-sip' ),
    array( 'zmdi-phone' => 'phone' ),
    array( 'zmdi-portable-wifi-changes' => 'portable-wifi-changes' ),
    array( 'zmdi-portable-wifi-off' => 'portable-wifi-off' ),
    array( 'zmdi-portable-wifi' => 'portable-wifi' ),
    array( 'zmdi-radio' => 'radio' ),
    array( 'zmdi-reader' => 'reader' ),
    array( 'zmdi-remote-control-alt' => 'remote-control-alt' ),
    array( 'zmdi-remote-control' => 'remote-control' ),
    array( 'zmdi-router' => 'router' ),
    array( 'zmdi-scanner' => 'scanner' ),
    array( 'zmdi-smartphone-android' => 'smartphone-android' ),
    array( 'zmdi-smartphone-download' => 'smartphone-download' ),
    array( 'zmdi-smartphone-erase' => 'smartphone-erase' ),
    array( 'zmdi-smartphone-info' => 'smartphone-info' ),
    array( 'zmdi-smartphone-iphone' => 'smartphone-iphone' ),
    array( 'zmdi-smartphone-landscape-lock' => 'smartphone-landscape-lock' ),
    array( 'zmdi-smartphone-landscape' => 'smartphone-landscape' ),
    array( 'zmdi-smartphone-lock' => 'smartphone-lock' ),
    array( 'zmdi-smartphone-portrait-lock' => 'smartphone-portrait-lock' ),
    array( 'zmdi-smartphone-ring' => 'smartphone-ring' ),
    array( 'zmdi-smartphone-setting' => 'smartphone-setting' ),
    array( 'zmdi-smartphone-setup' => 'smartphone-setup' ),
    array( 'zmdi-smartphone' => 'smartphone' ),
    array( 'zmdi-speaker' => 'speaker' ),
    array( 'zmdi-tablet-android' => 'tablet-android' ),
    array( 'zmdi-tablet-mac' => 'tablet-mac' ),
    array( 'zmdi-tablet' => 'tablet' ),
    array( 'zmdi-tv-alt-play' => 'tv-alt-play' ),
    array( 'zmdi-tv-list' => 'tv-list' ),
    array( 'zmdi-tv-play' => 'tv-play' ),
    array( 'zmdi-tv' => 'tv' ),
    array( 'zmdi-usb' => 'usb' ),
    array( 'zmdi-videocam-off' => 'videocam-off' ),
    array( 'zmdi-videocam-switch' => 'videocam-switch' ),
    array( 'zmdi-videocam' => 'videocam' ),
    array( 'zmdi-watch' => 'watch' ),
    array( 'zmdi-wifi-alt-2' => 'wifi-alt-2' ),
    array( 'zmdi-wifi-alt' => 'wifi-alt' ),
    array( 'zmdi-wifi-info' => 'wifi-info' ),
    array( 'zmdi-wifi-lock' => 'wifi-lock' ),
    array( 'zmdi-wifi-off' => 'wifi-off' ),
    array( 'zmdi-wifi-outline' => 'wifi-outline' ),
    array( 'zmdi-wifi' => 'wifi' ),
    array( 'zmdi-arrow-left-bottom' => 'arrow-left-bottom' ),
    array( 'zmdi-arrow-left' => 'arrow-left' ),
    array( 'zmdi-arrow-merge' => 'arrow-merge' ),
    array( 'zmdi-arrow-missed' => 'arrow-missed' ),
    array( 'zmdi-arrow-right-top' => 'arrow-right-top' ),
    array( 'zmdi-arrow-right' => 'arrow-right' ),
    array( 'zmdi-arrow-split' => 'arrow-split' ),
    array( 'zmdi-arrows' => 'arrows' ),
    array( 'zmdi-caret-down-circle' => 'caret-down-circle' ),
    array( 'zmdi-caret-down' => 'caret-down' ),
    array( 'zmdi-caret-left-circle' => 'caret-left-circle' ),
    array( 'zmdi-caret-left' => 'caret-left' ),
    array( 'zmdi-caret-right-circle' => 'caret-right-circle' ),
    array( 'zmdi-caret-right' => 'caret-right' ),
    array( 'zmdi-caret-up-circle' => 'caret-up-circle' ),
    array( 'zmdi-caret-up' => 'caret-up' ),
    array( 'zmdi-chevron-down' => 'chevron-down' ),
    array( 'zmdi-chevron-left' => 'chevron-left' ),
    array( 'zmdi-chevron-right' => 'chevron-right' ),
    array( 'zmdi-chevron-up' => 'chevron-up' ),
    array( 'zmdi-forward' => 'forward' ),
    array( 'zmdi-long-arrow-down' => 'long-arrow-down' ),
    array( 'zmdi-long-arrow-left' => 'long-arrow-left' ),
    array( 'zmdi-long-arrow-return' => 'long-arrow-return' ),
    array( 'zmdi-long-arrow-right' => 'long-arrow-right' ),
    array( 'zmdi-long-arrow-tab' => 'long-arrow-tab' ),
    array( 'zmdi-long-arrow-up' => 'long-arrow-up' ),
    array( 'zmdi-rotate-ccw' => 'rotate-ccw' ),
    array( 'zmdi-rotate-cw' => 'rotate-cw' ),
    array( 'zmdi-rotate-left' => 'rotate-left' ),
    array( 'zmdi-rotate-right' => 'rotate-right' ),
    array( 'zmdi-square-down' => 'square-down' ),
    array( 'zmdi-square-right' => 'square-right' ),
    array( 'zmdi-swap-alt' => 'swap-alt' ),
    array( 'zmdi-swap-vertical-circle' => 'swap-vertical-circle' ),
    array( 'zmdi-swap-vertical' => 'swap-vertical' ),
    array( 'zmdi-swap' => 'swap' ),
    array( 'zmdi-trending-down' => 'trending-down' ),
    array( 'zmdi-trending-flat' => 'trending-flat' ),
    array( 'zmdi-trending-up' => 'trending-up' ),
    array( 'zmdi-unfold-less' => 'unfold-less' ),
    array( 'zmdi-unfold-more' => 'unfold-more' ),
    array( 'zmdi-apps' => 'apps' ),
    array( 'zmdi-grid-off' => 'grid-off' ),
    array( 'zmdi-grid' => 'grid' ),
    array( 'zmdi-view-agenda' => 'view-agenda' ),
    array( 'zmdi-view-array' => 'view-array' ),
    array( 'zmdi-view-carousel' => 'view-carousel' ),
    array( 'zmdi-view-column' => 'view-column' ),
    array( 'zmdi-view-comfy' => 'view-comfy' ),
    array( 'zmdi-view-compact' => 'view-compact' ),
    array( 'zmdi-view-dashboard' => 'view-dashboard' ),
    array( 'zmdi-view-day' => 'view-day' ),
    array( 'zmdi-view-headline' => 'view-headline' ),
    array( 'zmdi-view-list-alt' => 'view-list-alt' ),
    array( 'zmdi-view-list' => 'view-list' ),
    array( 'zmdi-view-module' => 'view-module' ),
    array( 'zmdi-view-quilt' => 'view-quilt' ),
    array( 'zmdi-view-stream' => 'view-stream' ),
    array( 'zmdi-view-subtitles' => 'view-subtitles' ),
    array( 'zmdi-view-toc' => 'view-toc' ),
    array( 'zmdi-view-web' => 'view-web' ),
    array( 'zmdi-view-week' => 'view-week' ),
    array( 'zmdi-widgets' => 'widgets' ),
    array( 'zmdi-alarm-check' => 'alarm-check' ),
    array( 'zmdi-alarm-off' => 'alarm-off' ),
    array( 'zmdi-alarm-plus' => 'alarm-plus' ),
    array( 'zmdi-alarm-snooze' => 'alarm-snooze' ),
    array( 'zmdi-alarm' => 'alarm' ),
    array( 'zmdi-calendar-alt' => 'calendar-alt' ),
    array( 'zmdi-calendar-check' => 'calendar-check' ),
    array( 'zmdi-calendar-close' => 'calendar-close' ),
    array( 'zmdi-calendar-note' => 'calendar-note' ),
    array( 'zmdi-calendar' => 'calendar' ),
    array( 'zmdi-time-countdown' => 'time-countdown' ),
    array( 'zmdi-time-interval' => 'time-interval' ),
    array( 'zmdi-time-restore-setting' => 'time-restore-setting' ),
    array( 'zmdi-time-restore' => 'time-restore' ),
    array( 'zmdi-time' => 'time' ),
    array( 'zmdi-timer-off' => 'timer-off' ),
    array( 'zmdi-timer' => 'timer' ),
    array( 'zmdi-android-alt' => 'android-alt' ),
    array( 'zmdi-android' => 'android' ),
    array( 'zmdi-apple' => 'apple' ),
    array( 'zmdi-behance' => 'behance' ),
    array( 'zmdi-codepen' => 'codepen' ),
    array( 'zmdi-dribbble' => 'dribbble' ),
    array( 'zmdi-dropbox' => 'dropbox' ),
    array( 'zmdi-evernote' => 'evernote' ),
    array( 'zmdi-facebook-box' => 'facebook-box' ),
    array( 'zmdi-facebook' => 'facebook' ),
    array( 'zmdi-github-box' => 'github-box' ),
    array( 'zmdi-github' => 'github' ),
    array( 'zmdi-google-drive' => 'google-drive' ),
    array( 'zmdi-google-earth' => 'google-earth' ),
    array( 'zmdi-google-glass' => 'google-glass' ),
    array( 'zmdi-google-maps' => 'google-maps' ),
    array( 'zmdi-google-pages' => 'google-pages' ),
    array( 'zmdi-google-play' => 'google-play' ),
    array( 'zmdi-google-plus-box' => 'google-plus-box' ),
    array( 'zmdi-google-plus' => 'google-plus' ),
    array( 'zmdi-google' => 'google' ),
    array( 'zmdi-instagram' => 'instagram' ),
    array( 'zmdi-language-css3' => 'language-css3' ),
    array( 'zmdi-language-html5' => 'language-html5' ),
    array( 'zmdi-language-javascript' => 'language-javascript' ),
    array( 'zmdi-language-python-alt' => 'language-python-alt' ),
    array( 'zmdi-language-python' => 'language-python' ),
    array( 'zmdi-lastfm' => 'lastfm' ),
    array( 'zmdi-linkedin-box' => 'linkedin-box' ),
    array( 'zmdi-paypal' => 'paypal' ),
    array( 'zmdi-pinterest-box' => 'pinterest-box' ),
    array( 'zmdi-pocket' => 'pocket' ),
    array( 'zmdi-polymer' => 'polymer' ),
    array( 'zmdi-share' => 'share' ),
    array( 'zmdi-stackoverflow' => 'stackoverflow' ),
    array( 'zmdi-steam-square' => 'steam-square' ),
    array( 'zmdi-steam' => 'steam' ),
    array( 'zmdi-twitter-box' => 'twitter-box' ),
    array( 'zmdi-twitter' => 'twitter' ),
    array( 'zmdi-vk' => 'vk' ),
    array( 'zmdi-wikipedia' => 'wikipedia' ),
    array( 'zmdi-windows' => 'windows' ),
    array( 'zmdi-aspect-ratio-alt' => 'aspect-ratio-alt' ),
    array( 'zmdi-aspect-ratio' => 'aspect-ratio' ),
    array( 'zmdi-blur-circular' => 'blur-circular' ),
    array( 'zmdi-blur-linear' => 'blur-linear' ),
    array( 'zmdi-blur-off' => 'blur-off' ),
    array( 'zmdi-blur' => 'blur' ),
    array( 'zmdi-brightness-2' => 'brightness-2' ),
    array( 'zmdi-brightness-3' => 'brightness-3' ),
    array( 'zmdi-brightness-4' => 'brightness-4' ),
    array( 'zmdi-brightness-5' => 'brightness-5' ),
    array( 'zmdi-brightness-6' => 'brightness-6' ),
    array( 'zmdi-brightness-7' => 'brightness-7' ),
    array( 'zmdi-brightness-auto' => 'brightness-auto' ),
    array( 'zmdi-brightness-setting' => 'brightness-setting' ),
    array( 'zmdi-broken-image' => 'broken-image' ),
    array( 'zmdi-center-focus-strong' => 'center-focus-strong' ),
    array( 'zmdi-center-focus-weak' => 'center-focus-weak' ),
    array( 'zmdi-compare' => 'compare' ),
    array( 'zmdi-crop-16-9' => 'crop-16-9' ),
    array( 'zmdi-crop-3-2' => 'crop-3-2' ),
    array( 'zmdi-crop-5-4' => 'crop-5-4' ),
    array( 'zmdi-crop-7-5' => 'crop-7-5' ),
    array( 'zmdi-crop-din' => 'crop-din' ),
    array( 'zmdi-crop-free' => 'crop-free' ),
    array( 'zmdi-crop-landscape' => 'crop-landscape' ),
    array( 'zmdi-crop-portrait' => 'crop-portrait' ),
    array( 'zmdi-crop-square' => 'crop-square' ),
    array( 'zmdi-exposure-alt' => 'exposure-alt' ),
    array( 'zmdi-exposure' => 'exposure' ),
    array( 'zmdi-filter-b-and-w' => 'filter-b-and-w' ),
    array( 'zmdi-filter-center-focus' => 'filter-center-focus' ),
    array( 'zmdi-filter-frames' => 'filter-frames' ),
    array( 'zmdi-filter-tilt-shift' => 'filter-tilt-shift' ),
    array( 'zmdi-gradient' => 'gradient' ),
    array( 'zmdi-grain' => 'grain' ),
    array( 'zmdi-graphic-eq' => 'graphic-eq' ),
    array( 'zmdi-hdr-off' => 'hdr-off' ),
    array( 'zmdi-hdr-strong' => 'hdr-strong' ),
    array( 'zmdi-hdr-weak' => 'hdr-weak' ),
    array( 'zmdi-hdr' => 'hdr' ),
    array( 'zmdi-iridescent' => 'iridescent' ),
    array( 'zmdi-leak-off' => 'leak-off' ),
    array( 'zmdi-leak' => 'leak' ),
    array( 'zmdi-looks' => 'looks' ),
    array( 'zmdi-loupe' => 'loupe' ),
    array( 'zmdi-panorama-horizontal' => 'panorama-horizontal' ),
    array( 'zmdi-panorama-vertical' => 'panorama-vertical' ),
    array( 'zmdi-panorama-wide-angle' => 'panorama-wide-angle' ),
    array( 'zmdi-photo-size-select-large' => 'photo-size-select-large' ),
    array( 'zmdi-photo-size-select-small' => 'photo-size-select-small' ),
    array( 'zmdi-picture-in-picture' => 'picture-in-picture' ),
    array( 'zmdi-slideshow' => 'slideshow' ),
    array( 'zmdi-texture' => 'texture' ),
    array( 'zmdi-tonality' => 'tonality' ),
    array( 'zmdi-vignette' => 'vignette' ),
    array( 'zmdi-wb-auto' => 'wb-auto' ),
    array( 'zmdi-eject-alt' => 'eject-alt' ),
    array( 'zmdi-eject' => 'eject' ),
    array( 'zmdi-equalizer' => 'equalizer' ),
    array( 'zmdi-fast-forward' => 'fast-forward' ),
    array( 'zmdi-fast-rewind' => 'fast-rewind' ),
    array( 'zmdi-forward-10' => 'forward-10' ),
    array( 'zmdi-forward-30' => 'forward-30' ),
    array( 'zmdi-forward-5' => 'forward-5' ),
    array( 'zmdi-hearing' => 'hearing' ),
    array( 'zmdi-pause-circle-outline' => 'pause-circle-outline' ),
    array( 'zmdi-pause-circle' => 'pause-circle' ),
    array( 'zmdi-pause' => 'pause' ),
    array( 'zmdi-play-circle-outline' => 'play-circle-outline' ),
    array( 'zmdi-play-circle' => 'play-circle' ),
    array( 'zmdi-play' => 'play' ),
    array( 'zmdi-playlist-audio' => 'playlist-audio' ),
    array( 'zmdi-playlist-plus' => 'playlist-plus' ),
    array( 'zmdi-repeat-one' => 'repeat-one' ),
    array( 'zmdi-repeat' => 'repeat' ),
    array( 'zmdi-replay-10' => 'replay-10' ),
    array( 'zmdi-replay-30' => 'replay-30' ),
    array( 'zmdi-replay-5' => 'replay-5' ),
    array( 'zmdi-replay' => 'replay' ),
    array( 'zmdi-shuffle' => 'shuffle' ),
    array( 'zmdi-skip-next' => 'skip-next' ),
    array( 'zmdi-skip-previous' => 'skip-previous' ),
    array( 'zmdi-stop' => 'stop' ),
    array( 'zmdi-surround-sound' => 'surround-sound' ),
    array( 'zmdi-tune' => 'tune' ),
    array( 'zmdi-volume-down' => 'volume-down' ),
    array( 'zmdi-volume-mute' => 'volume-mute' ),
    array( 'zmdi-volume-off' => 'volume-off' ),
    array( 'zmdi-volume-up' => 'volume-up' ),
    array( 'zmdi-n-1-square' => 'n-1-square' ),
    array( 'zmdi-n-2-square' => 'n-2-square' ),
    array( 'zmdi-n-3-square' => 'n-3-square' ),
    array( 'zmdi-n-4-square' => 'n-4-square' ),
    array( 'zmdi-n-5-square' => 'n-5-square' ),
    array( 'zmdi-n-6-square' => 'n-6-square' ),
    array( 'zmdi-neg-1' => 'neg-1' ),
    array( 'zmdi-neg-2' => 'neg-2' ),
    array( 'zmdi-plus-1' => 'plus-1' ),
    array( 'zmdi-plus-2' => 'plus-2' ),
    array( 'zmdi-sec-10' => 'sec-10' ),
    array( 'zmdi-sec-3' => 'sec-3' ),
    array( 'zmdi-zero' => 'zero' ),
    array( 'zmdi-airline-seat-flat-angled' => 'airline-seat-flat-angled' ),
    array( 'zmdi-airline-seat-flat' => 'airline-seat-flat' ),
    array( 'zmdi-airline-seat-individual-suite' => 'airline-seat-individual-suite' ),
    array( 'zmdi-airline-seat-legroom-extra' => 'airline-seat-legroom-extra' ),
    array( 'zmdi-airline-seat-legroom-normal' => 'airline-seat-legroom-normal' ),
    array( 'zmdi-airline-seat-legroom-reduced' => 'airline-seat-legroom-reduced' ),
    array( 'zmdi-airline-seat-recline-extra' => 'airline-seat-recline-extra' ),
    array( 'zmdi-airline-seat-recline-normal' => 'airline-seat-recline-normal' ),
    array( 'zmdi-airplay' => 'airplay' ),
    array( 'zmdi-closed-caption' => 'closed-caption' ),
    array( 'zmdi-confirmation-number' => 'confirmation-number' ),
    array( 'zmdi-developer-board' => 'developer-board' ),
    array( 'zmdi-disc-full' => 'disc-full' ),
    array( 'zmdi-explicit' => 'explicit' ),
    array( 'zmdi-flight-land' => 'flight-land' ),
    array( 'zmdi-flight-takeoff' => 'flight-takeoff' ),
    array( 'zmdi-flip-to-back' => 'flip-to-back' ),
    array( 'zmdi-flip-to-front' => 'flip-to-front' ),
    array( 'zmdi-group-work' => 'group-work' ),
    array( 'zmdi-hd' => 'hd' ),
    array( 'zmdi-hq' => 'hq' ),
    array( 'zmdi-markunread-mailbox' => 'markunread-mailbox' ),
    array( 'zmdi-memory' => 'memory' ),
    array( 'zmdi-nfc' => 'nfc' ),
    array( 'zmdi-play-for-work' => 'play-for-work' ),
    array( 'zmdi-power-input' => 'power-input' ),
    array( 'zmdi-present-to-all' => 'present-to-all' ),
    array( 'zmdi-satellite' => 'satellite' ),
    array( 'zmdi-tap-and-play' => 'tap-and-play' ),
    array( 'zmdi-vibration' => 'vibration' ),
    array( 'zmdi-voicemail' => 'voicemail' ),
    array( 'zmdi-group' => 'group' ),
    array( 'zmdi-rss' => 'rss' ),
    array( 'zmdi-shape' => 'shape' ),
    array( 'zmdi-spinner' => 'spinner' ),
    array( 'zmdi-ungroup' => 'ungroup' ),
    array( 'zmdi-500px' => '500px' ),
    array( 'zmdi-8tracks' => '8tracks' ),
    array( 'zmdi-amazon' => 'amazon' ),
    array( 'zmdi-blogger' => 'blogger' ),
    array( 'zmdi-delicious' => 'delicious' ),
    array( 'zmdi-disqus' => 'disqus' ),
    array( 'zmdi-flattr' => 'flattr' ),
    array( 'zmdi-flickr' => 'flickr' ),
    array( 'zmdi-github-alt' => 'github-alt' ),
    array( 'zmdi-google-old' => 'google-old' ),
    array( 'zmdi-linkedin' => 'linkedin' ),
    array( 'zmdi-odnoklassniki' => 'odnoklassniki' ),
    array( 'zmdi-outlook' => 'outlook' ),
    array( 'zmdi-paypal-alt' => 'paypal-alt' ),
    array( 'zmdi-pinterest' => 'pinterest' ),
    array( 'zmdi-playstation' => 'playstation' ),
    array( 'zmdi-reddit' => 'reddit' ),
    array( 'zmdi-skype' => 'skype' ),
    array( 'zmdi-slideshare' => 'slideshare' ),
    array( 'zmdi-soundcloud' => 'soundcloud' ),
    array( 'zmdi-tumblr' => 'tumblr' ),
    array( 'zmdi-twitch' => 'twitch' ),
    array( 'zmdi-vimeo' => 'vimeo' ),
    array( 'zmdi-whatsapp' => 'whatsapp' ),
    array( 'zmdi-xbox' => 'xbox' ),
    array( 'zmdi-yahoo' => 'yahoo' ),
    array( 'zmdi-youtube-play' => 'youtube-play' ),
    array( 'zmdi-youtube' => 'youtube' ),
    array( 'zmdi-3d-rotation' => '3d-rotation' ),
    array( 'zmdi-airplane-off' => 'airplane-off' ),
    array( 'zmdi-airplane' => 'airplane' ),
    array( 'zmdi-album' => 'album' ),
    array( 'zmdi-archive' => 'archive' ),
    array( 'zmdi-assignment-account' => 'assignment-account' ),
    array( 'zmdi-assignment-alert' => 'assignment-alert' ),
    array( 'zmdi-assignment-check' => 'assignment-check' ),
    array( 'zmdi-assignment-o' => 'assignment-o' ),
    array( 'zmdi-assignment-return' => 'assignment-return' ),
    array( 'zmdi-assignment-returned' => 'assignment-returned' ),
    array( 'zmdi-assignment' => 'assignment' ),
    array( 'zmdi-attachment-alt' => 'attachment-alt' ),
    array( 'zmdi-attachment' => 'attachment' ),
    array( 'zmdi-audio' => 'audio' ),
    array( 'zmdi-badge-check' => 'badge-check' ),
    array( 'zmdi-balance-wallet' => 'balance-wallet' ),
    array( 'zmdi-balance' => 'balance' ),
    array( 'zmdi-battery-alert' => 'battery-alert' ),
    array( 'zmdi-battery-flash' => 'battery-flash' ),
    array( 'zmdi-battery-unknown' => 'battery-unknown' ),
    array( 'zmdi-battery' => 'battery' ),
    array( 'zmdi-bike' => 'bike' ),
    array( 'zmdi-block-alt' => 'block-alt' ),
    array( 'zmdi-block' => 'block' ),
    array( 'zmdi-boat' => 'boat' ),
    array( 'zmdi-book-image' => 'book-image' ),
    array( 'zmdi-book' => 'book' ),
    array( 'zmdi-bookmark-outline' => 'bookmark-outline' ),
    array( 'zmdi-bookmark' => 'bookmark' ),
    array( 'zmdi-brush' => 'brush' ),
    array( 'zmdi-bug' => 'bug' ),
    array( 'zmdi-bus' => 'bus' ),
    array( 'zmdi-cake' => 'cake' ),
    array( 'zmdi-car-taxi' => 'car-taxi' ),
    array( 'zmdi-car-wash' => 'car-wash' ),
    array( 'zmdi-car' => 'car' ),
    array( 'zmdi-card-giftcard' => 'card-giftcard' ),
    array( 'zmdi-card-membership' => 'card-membership' ),
    array( 'zmdi-card-travel' => 'card-travel' ),
    array( 'zmdi-card' => 'card' ),
    array( 'zmdi-case-check' => 'case-check' ),
    array( 'zmdi-case-download' => 'case-download' ),
    array( 'zmdi-case-play' => 'case-play' ),
    array( 'zmdi-case' => 'case' ),
    array( 'zmdi-cast-connected' => 'cast-connected' ),
    array( 'zmdi-cast' => 'cast' ),
    array( 'zmdi-chart-donut' => 'chart-donut' ),
    array( 'zmdi-chart' => 'chart' ),
    array( 'zmdi-city-alt' => 'city-alt' ),
    array( 'zmdi-city' => 'city' ),
    array( 'zmdi-close-circle-o' => 'close-circle-o' ),
    array( 'zmdi-close-circle' => 'close-circle' ),
    array( 'zmdi-close' => 'close' ),
    array( 'zmdi-cocktail' => 'cocktail' ),
    array( 'zmdi-code-setting' => 'code-setting' ),
    array( 'zmdi-code-smartphone' => 'code-smartphone' ),
    array( 'zmdi-code' => 'code' ),
    array( 'zmdi-coffee' => 'coffee' ),
    array( 'zmdi-collection-bookmark' => 'collection-bookmark' ),
    array( 'zmdi-collection-case-play' => 'collection-case-play' ),
    array( 'zmdi-collection-folder-image' => 'collection-folder-image' ),
    array( 'zmdi-collection-image-o' => 'collection-image-o' ),
    array( 'zmdi-collection-image' => 'collection-image' ),
    array( 'zmdi-collection-item-1' => 'collection-item-1' ),
    array( 'zmdi-collection-item-2' => 'collection-item-2' ),
    array( 'zmdi-collection-item-3' => 'collection-item-3' ),
    array( 'zmdi-collection-item-4' => 'collection-item-4' ),
    array( 'zmdi-collection-item-5' => 'collection-item-5' ),
    array( 'zmdi-collection-item-6' => 'collection-item-6' ),
    array( 'zmdi-collection-item-7' => 'collection-item-7' ),
    array( 'zmdi-collection-item-8' => 'collection-item-8' ),
    array( 'zmdi-collection-item-9-plus' => 'collection-item-9-plus' ),
    array( 'zmdi-collection-item-9' => 'collection-item-9' ),
    array( 'zmdi-collection-item' => 'collection-item' ),
    array( 'zmdi-collection-music' => 'collection-music' ),
    array( 'zmdi-collection-pdf' => 'collection-pdf' ),
    array( 'zmdi-collection-plus' => 'collection-plus' ),
    array( 'zmdi-collection-speaker' => 'collection-speaker' ),
    array( 'zmdi-collection-text' => 'collection-text' ),
    array( 'zmdi-collection-video' => 'collection-video' ),
    array( 'zmdi-compass' => 'compass' ),
    array( 'zmdi-cutlery' => 'cutlery' ),
    array( 'zmdi-delete' => 'delete' ),
    array( 'zmdi-dialpad' => 'dialpad' ),
    array( 'zmdi-dns' => 'dns' ),
    array( 'zmdi-drink' => 'drink' ),
    array( 'zmdi-edit' => 'edit' ),
    array( 'zmdi-email-open' => 'email-open' ),
    array( 'zmdi-email' => 'email' ),
    array( 'zmdi-eye-off' => 'eye-off' ),
    array( 'zmdi-eye' => 'eye' ),
    array( 'zmdi-eyedropper' => 'eyedropper' ),
    array( 'zmdi-favorite-outline' => 'favorite-outline' ),
    array( 'zmdi-favorite' => 'favorite' ),
    array( 'zmdi-filter-list' => 'filter-list' ),
    array( 'zmdi-fire' => 'fire' ),
    array( 'zmdi-flag' => 'flag' ),
    array( 'zmdi-flare' => 'flare' ),
    array( 'zmdi-flash-auto' => 'flash-auto' ),
    array( 'zmdi-flash-off' => 'flash-off' ),
    array( 'zmdi-flash' => 'flash' ),
    array( 'zmdi-flip' => 'flip' ),
    array( 'zmdi-flower-alt' => 'flower-alt' ),
    array( 'zmdi-flower' => 'flower' ),
    array( 'zmdi-font' => 'font' ),
    array( 'zmdi-fullscreen-alt' => 'fullscreen-alt' ),
    array( 'zmdi-fullscreen-exit' => 'fullscreen-exit' ),
    array( 'zmdi-fullscreen' => 'fullscreen' ),
    array( 'zmdi-functions' => 'functions' ),
    array( 'zmdi-gas-station' => 'gas-station' ),
    array( 'zmdi-gesture' => 'gesture' ),
    array( 'zmdi-globe-alt' => 'globe-alt' ),
    array( 'zmdi-globe-lock' => 'globe-lock' ),
    array( 'zmdi-globe' => 'globe' ),
    array( 'zmdi-graduation-cap' => 'graduation-cap' ),
    array( 'zmdi-home' => 'home' ),
    array( 'zmdi-hospital-alt' => 'hospital-alt' ),
    array( 'zmdi-hospital' => 'hospital' ),
    array( 'zmdi-hotel' => 'hotel' ),
    array( 'zmdi-hourglass-alt' => 'hourglass-alt' ),
    array( 'zmdi-hourglass-outline' => 'hourglass-outline' ),
    array( 'zmdi-hourglass' => 'hourglass' ),
    array( 'zmdi-http' => 'http' ),
    array( 'zmdi-image-alt' => 'image-alt' ),
    array( 'zmdi-image-o' => 'image-o' ),
    array( 'zmdi-image' => 'image' ),
    array( 'zmdi-inbox' => 'inbox' ),
    array( 'zmdi-invert-colors-off' => 'invert-colors-off' ),
    array( 'zmdi-invert-colors' => 'invert-colors' ),
    array( 'zmdi-key' => 'key' ),
    array( 'zmdi-label-alt-outline' => 'label-alt-outline' ),
    array( 'zmdi-label-alt' => 'label-alt' ),
    array( 'zmdi-label-heart' => 'label-heart' ),
    array( 'zmdi-label' => 'label' ),
    array( 'zmdi-labels' => 'labels' ),
    array( 'zmdi-lamp' => 'lamp' ),
    array( 'zmdi-landscape' => 'landscape' ),
    array( 'zmdi-layers-off' => 'layers-off' ),
    array( 'zmdi-layers' => 'layers' ),
    array( 'zmdi-library' => 'library' ),
    array( 'zmdi-link' => 'link' ),
    array( 'zmdi-lock-open' => 'lock-open' ),
    array( 'zmdi-lock-outline' => 'lock-outline' ),
    array( 'zmdi-lock' => 'lock' ),
    array( 'zmdi-mail-reply-all' => 'mail-reply-all' ),
    array( 'zmdi-mail-reply' => 'mail-reply' ),
    array( 'zmdi-mail-send' => 'mail-send' ),
    array( 'zmdi-mall' => 'mall' ),
    array( 'zmdi-map' => 'map' ),
    array( 'zmdi-menu' => 'menu' ),
    array( 'zmdi-money-box' => 'money-box' ),
    array( 'zmdi-money-off' => 'money-off' ),
    array( 'zmdi-money' => 'money' ),
    array( 'zmdi-more-vert' => 'more-vert' ),
    array( 'zmdi-more' => 'more' ),
    array( 'zmdi-movie-alt' => 'movie-alt' ),
    array( 'zmdi-movie' => 'movie' ),
    array( 'zmdi-nature-people' => 'nature-people' ),
    array( 'zmdi-nature' => 'nature' ),
    array( 'zmdi-navigation' => 'navigation' ),
    array( 'zmdi-open-in-browser' => 'open-in-browser' ),
    array( 'zmdi-open-in-new' => 'open-in-new' ),
    array( 'zmdi-palette' => 'palette' ),
    array( 'zmdi-parking' => 'parking' ),
    array( 'zmdi-pin-account' => 'pin-account' ),
    array( 'zmdi-pin-assistant' => 'pin-assistant' ),
    array( 'zmdi-pin-drop' => 'pin-drop' ),
    array( 'zmdi-pin-help' => 'pin-help' ),
    array( 'zmdi-pin-off' => 'pin-off' ),
    array( 'zmdi-pin' => 'pin' ),
    array( 'zmdi-pizza' => 'pizza' ),
    array( 'zmdi-plaster' => 'plaster' ),
    array( 'zmdi-power-setting' => 'power-setting' ),
    array( 'zmdi-power' => 'power' ),
    array( 'zmdi-print' => 'print' ),
    array( 'zmdi-puzzle-piece' => 'puzzle-piece' ),
    array( 'zmdi-quote' => 'quote' ),
    array( 'zmdi-railway' => 'railway' ),
    array( 'zmdi-receipt' => 'receipt' ),
    array( 'zmdi-refresh-alt' => 'refresh-alt' ),
    array( 'zmdi-refresh-sync-alert' => 'refresh-sync-alert' ),
    array( 'zmdi-refresh-sync-off' => 'refresh-sync-off' ),
    array( 'zmdi-refresh-sync' => 'refresh-sync' ),
    array( 'zmdi-refresh' => 'refresh' ),
    array( 'zmdi-roller' => 'roller' ),
    array( 'zmdi-ruler' => 'ruler' ),
    array( 'zmdi-scissors' => 'scissors' ),
    array( 'zmdi-screen-rotation-lock' => 'screen-rotation-lock' ),
    array( 'zmdi-screen-rotation' => 'screen-rotation' ),
    array( 'zmdi-search-for' => 'search-for' ),
    array( 'zmdi-search-in-file' => 'search-in-file' ),
    array( 'zmdi-search-in-page' => 'search-in-page' ),
    array( 'zmdi-search-replace' => 'search-replace' ),
    array( 'zmdi-search' => 'search' ),
    array( 'zmdi-seat' => 'seat' ),
    array( 'zmdi-settings-square' => 'settings-square' ),
    array( 'zmdi-settings' => 'settings' ),
    array( 'zmdi-shield-check' => 'shield-check' ),
    array( 'zmdi-shield-security' => 'shield-security' ),
    array( 'zmdi-shopping-basket' => 'shopping-basket' ),
    array( 'zmdi-shopping-cart-plus' => 'shopping-cart-plus' ),
    array( 'zmdi-shopping-cart' => 'shopping-cart' ),
    array( 'zmdi-sign-in' => 'sign-in' ),
    array( 'zmdi-sort-amount-asc' => 'sort-amount-asc' ),
    array( 'zmdi-sort-amount-desc' => 'sort-amount-desc' ),
    array( 'zmdi-sort-asc' => 'sort-asc' ),
    array( 'zmdi-sort-desc' => 'sort-desc' ),
    array( 'zmdi-spellcheck' => 'spellcheck' ),
    array( 'zmdi-storage' => 'storage' ),
    array( 'zmdi-store-24' => 'store-24' ),
    array( 'zmdi-store' => 'store' ),
    array( 'zmdi-subway' => 'subway' ),
    array( 'zmdi-sun' => 'sun' ),
    array( 'zmdi-tab-unselected' => 'tab-unselected' ),
    array( 'zmdi-tab' => 'tab' ),
    array( 'zmdi-tag-close' => 'tag-close' ),
    array( 'zmdi-tag-more' => 'tag-more' ),
    array( 'zmdi-tag' => 'tag' ),
    array( 'zmdi-thumb-down' => 'thumb-down' ),
    array( 'zmdi-thumb-up-down' => 'thumb-up-down' ),
    array( 'zmdi-thumb-up' => 'thumb-up' ),
    array( 'zmdi-ticket-star' => 'ticket-star' ),
    array( 'zmdi-toll' => 'toll' ),
    array( 'zmdi-toys' => 'toys' ),
    array( 'zmdi-traffic' => 'traffic' ),
    array( 'zmdi-translate' => 'translate' ),
    array( 'zmdi-triangle-down' => 'triangle-down' ),
    array( 'zmdi-triangle-up' => 'triangle-up' ),
    array( 'zmdi-truck' => 'truck' ),
    array( 'zmdi-turning-sign' => 'turning-sign' ),
    array( 'zmdi-wallpaper' => 'wallpaper' ),
    array( 'zmdi-washing-machine' => 'washing-machine' ),
    array( 'zmdi-window-maximize' => 'window-maximize' ),
    array( 'zmdi-window-minimize' => 'window-minimize' ),
    array( 'zmdi-window-restore' => 'window-restore' ),
    array( 'zmdi-wrench' => 'wrench' ),
    array( 'zmdi-zoom-in' => 'zoom-in' ),
    array( 'zmdi-zoom-out' => 'zoom-out' ),
    array( 'zmdi-alert-circle-o' => 'alert-circle-o' ),
    array( 'zmdi-alert-circle' => 'alert-circle' ),
    array( 'zmdi-alert-octagon' => 'alert-octagon' ),
    array( 'zmdi-alert-polygon' => 'alert-polygon' ),
    array( 'zmdi-alert-triangle' => 'alert-triangle' ),
    array( 'zmdi-help-outline' => 'help-outline' ),
    array( 'zmdi-help' => 'help' ),
    array( 'zmdi-info-outline' => 'info-outline' ),
    array( 'zmdi-info' => 'info' ),
    array( 'zmdi-notifications-active' => 'notifications-active' ),
    array( 'zmdi-notifications-add' => 'notifications-add' ),
    array( 'zmdi-notifications-none' => 'notifications-none' ),
    array( 'zmdi-notifications-off' => 'notifications-off' ),
    array( 'zmdi-notifications-paused' => 'notifications-paused' ),
    array( 'zmdi-notifications' => 'notifications' ),
    array( 'zmdi-account-add' => 'account-add' ),
    array( 'zmdi-account-box-mail' => 'account-box-mail' ),
    array( 'zmdi-account-box-o' => 'account-box-o' ),
    array( 'zmdi-account-box-phone' => 'account-box-phone' ),
    array( 'zmdi-account-box' => 'account-box' ),
    array( 'zmdi-account-calendar' => 'account-calendar' ),
    array( 'zmdi-account-circle' => 'account-circle' ),
    array( 'zmdi-account-o' => 'account-o' ),
    array( 'zmdi-account' => 'account' ),
    array( 'zmdi-accounts-add' => 'accounts-add' ),
    array( 'zmdi-accounts-alt' => 'accounts-alt' ),
    array( 'zmdi-accounts-list-alt' => 'accounts-list-alt' ),
    array( 'zmdi-accounts-list' => 'accounts-list' ),
    array( 'zmdi-accounts-outline' => 'accounts-outline' ),
    array( 'zmdi-accounts' => 'accounts' ),
    array( 'zmdi-face' => 'face' ),
    array( 'zmdi-female' => 'female' ),
    array( 'zmdi-male-alt' => 'male-alt' ),
    array( 'zmdi-male-female' => 'male-female' ),
    array( 'zmdi-male' => 'male' ),
    array( 'zmdi-mood-bad' => 'mood-bad' ),
    array( 'zmdi-mood' => 'mood' ),
    array( 'zmdi-run' => 'run' ),
    array( 'zmdi-walk' => 'walk' ),
    array( 'zmdi-cloud-box' => 'cloud-box' ),
    array( 'zmdi-cloud-circle' => 'cloud-circle' ),
    array( 'zmdi-cloud-done' => 'cloud-done' ),
    array( 'zmdi-cloud-download' => 'cloud-download' ),
    array( 'zmdi-cloud-off' => 'cloud-off' ),
    array( 'zmdi-cloud-outline-alt' => 'cloud-outline-alt' ),
    array( 'zmdi-cloud-outline' => 'cloud-outline' ),
    array( 'zmdi-cloud-upload' => 'cloud-upload' ),
    array( 'zmdi-cloud' => 'cloud' ),
    array( 'zmdi-download' => 'download' ),
    array( 'zmdi-file-plus' => 'file-plus' ),
    array( 'zmdi-file-text' => 'file-text' ),
    array( 'zmdi-file' => 'file' ),
    array( 'zmdi-folder-outline' => 'folder-outline' ),
    array( 'zmdi-folder-person' => 'folder-person' ),
    array( 'zmdi-folder-star-alt' => 'folder-star-alt' ),
    array( 'zmdi-folder-star' => 'folder-star' ),
    array( 'zmdi-folder' => 'folder' ),
    array( 'zmdi-gif' => 'gif' ),
    array( 'zmdi-upload' => 'upload' ),
    array( 'zmdi-border-all' => 'border-all' ),
    array( 'zmdi-border-bottom' => 'border-bottom' ),
    array( 'zmdi-border-clear' => 'border-clear' ),
    array( 'zmdi-border-color' => 'border-color' ),
    array( 'zmdi-border-horizontal' => 'border-horizontal' ),
    array( 'zmdi-border-inner' => 'border-inner' ),
    array( 'zmdi-border-left' => 'border-left' ),
    array( 'zmdi-border-outer' => 'border-outer' ),
    array( 'zmdi-border-right' => 'border-right' ),
    array( 'zmdi-border-style' => 'border-style' ),
    array( 'zmdi-border-top' => 'border-top' ),
    array( 'zmdi-border-vertical' => 'border-vertical' ),
    array( 'zmdi-copy' => 'copy' ),
    array( 'zmdi-crop' => 'crop' ),
    array( 'zmdi-format-align-center' => 'format-align-center' ),
    array( 'zmdi-format-align-justify' => 'format-align-justify' ),
    array( 'zmdi-format-align-left' => 'format-align-left' ),
    array( 'zmdi-format-align-right' => 'format-align-right' ),
    array( 'zmdi-format-bold' => 'format-bold' ),
    array( 'zmdi-format-clear-all' => 'format-clear-all' ),
    array( 'zmdi-format-clear' => 'format-clear' ),
    array( 'zmdi-format-color-fill' => 'format-color-fill' ),
    array( 'zmdi-format-color-reset' => 'format-color-reset' ),
    array( 'zmdi-format-color-text' => 'format-color-text' ),
    array( 'zmdi-format-indent-decrease' => 'format-indent-decrease' ),
    array( 'zmdi-format-indent-increase' => 'format-indent-increase' ),
    array( 'zmdi-format-italic' => 'format-italic' ),
    array( 'zmdi-format-line-spacing' => 'format-line-spacing' ),
    array( 'zmdi-format-list-bulleted' => 'format-list-bulleted' ),
    array( 'zmdi-format-list-numbered' => 'format-list-numbered' ),
    array( 'zmdi-format-ltr' => 'format-ltr' ),
    array( 'zmdi-format-rtl' => 'format-rtl' ),
    array( 'zmdi-format-size' => 'format-size' ),
    array( 'zmdi-format-strikethrough-s' => 'format-strikethrough-s' ),
    array( 'zmdi-format-strikethrough' => 'format-strikethrough' ),
    array( 'zmdi-format-subject' => 'format-subject' ),
    array( 'zmdi-format-underlined' => 'format-underlined' ),
    array( 'zmdi-format-valign-bottom' => 'format-valign-bottom' ),
    array( 'zmdi-format-valign-center' => 'format-valign-center' ),
    array( 'zmdi-format-valign-top' => 'format-valign-top' ),
    array( 'zmdi-redo' => 'redo' ),
    array( 'zmdi-select-all' => 'select-all' ),
    array( 'zmdi-space-bar' => 'space-bar' ),
    array( 'zmdi-text-format' => 'text-format' ),
    array( 'zmdi-transform' => 'transform' ),
    array( 'zmdi-undo' => 'undo' ),
    array( 'zmdi-wrap-text' => 'wrap-text' ),
    array( 'zmdi-comment-alert' => 'comment-alert' ),
    array( 'zmdi-comment-alt-text' => 'comment-alt-text' ),
    array( 'zmdi-comment-alt' => 'comment-alt' ),
    array( 'zmdi-comment-edit' => 'comment-edit' ),
    array( 'zmdi-comment-image' => 'comment-image' ),
    array( 'zmdi-comment-list' => 'comment-list' ),
    array( 'zmdi-comment-more' => 'comment-more' ),
    array( 'zmdi-comment-outline' => 'comment-outline' ),
    array( 'zmdi-comment-text-alt' => 'comment-text-alt' ),
    array( 'zmdi-comment-text' => 'comment-text' ),
    array( 'zmdi-comment-video' => 'comment-video' ),
    array( 'zmdi-comment' => 'comment' ),
    array( 'zmdi-comments' => 'comments' ),
    array( 'zmdi-check-all' => 'check-all' ),
    array( 'zmdi-check-circle-u' => 'check-circle-u' ),
    array( 'zmdi-check-circle' => 'check-circle' ),
    array( 'zmdi-check-square' => 'check-square' ),
    array( 'zmdi-check' => 'check' ),
    array( 'zmdi-circle-o' => 'circle-o' ),
    array( 'zmdi-circle' => 'circle' ),
    array( 'zmdi-dot-circle-alt' => 'dot-circle-alt' ),
    array( 'zmdi-dot-circle' => 'dot-circle' ),
    array( 'zmdi-minus-circle-outline' => 'minus-circle-outline' ),
    array( 'zmdi-minus-circle' => 'minus-circle' ),
    array( 'zmdi-minus-square' => 'minus-square' ),
    array( 'zmdi-minus' => 'minus' ),
    array( 'zmdi-plus-circle-o-duplicate' => 'plus-circle-o-duplicate' ),
    array( 'zmdi-plus-circle-o' => 'plus-circle-o' ),
    array( 'zmdi-plus-circle' => 'plus-circle' ),
    array( 'zmdi-plus-square' => 'plus-square' ),
    array( 'zmdi-plus' => 'plus' ),
    array( 'zmdi-square-o' => 'square-o' ),
    array( 'zmdi-star-circle' => 'star-circle' ),
    array( 'zmdi-star-half' => 'star-half' ),
    array( 'zmdi-star-outline' => 'star-outline' ),
    array( 'zmdi-star' => 'star' ),
    array( 'zmdi-bluetooth-connected' => 'bluetooth-connected' ),
    array( 'zmdi-bluetooth-off' => 'bluetooth-off' ),
    array( 'zmdi-bluetooth-search' => 'bluetooth-search' ),
    array( 'zmdi-bluetooth-setting' => 'bluetooth-setting' ),
    array( 'zmdi-bluetooth' => 'bluetooth' ),
    array( 'zmdi-camera-add' => 'camera-add' ),
    array( 'zmdi-camera-alt' => 'camera-alt' ),
    array( 'zmdi-camera-bw' => 'camera-bw' ),
    array( 'zmdi-camera-front' => 'camera-front' ),
    array( 'zmdi-camera-mic' => 'camera-mic' ),
    array( 'zmdi-camera-party-mode' => 'camera-party-mode' ),
    array( 'zmdi-camera-rear' => 'camera-rear' ),
    array( 'zmdi-camera-roll' => 'camera-roll' ),
    array( 'zmdi-camera-switch' => 'camera-switch' ),
    array( 'zmdi-camera' => 'camera' ),
    array( 'zmdi-card-alert' => 'card-alert' ),
    array( 'zmdi-card-off' => 'card-off' ),
    array( 'zmdi-card-sd' => 'card-sd' ),
    array( 'zmdi-card-sim' => 'card-sim' ),
    array( 'zmdi-desktop-mac' => 'desktop-mac' ),
    array( 'zmdi-desktop-windows' => 'desktop-windows' ),
    array( 'zmdi-device-hub' => 'device-hub' ),
    array( 'zmdi-devices-off' => 'devices-off' ),
    array( 'zmdi-devices' => 'devices' ),
    array( 'zmdi-dock' => 'dock' ),
    array( 'zmdi-floppy' => 'floppy' ),
    array( 'zmdi-gamepad' => 'gamepad' ),
    array( 'zmdi-gps-dot' => 'gps-dot' ),
    array( 'zmdi-gps-off' => 'gps-off' ),
    array( 'zmdi-gps' => 'gps' ),
    array( 'zmdi-headset-mic' => 'headset-mic' ),
    array( 'zmdi-headset' => 'headset' ),
    array( 'zmdi-input-antenna' => 'input-antenna' ),
    array( 'zmdi-input-composite' => 'input-composite' ),
    array( 'zmdi-input-hdmi' => 'input-hdmi' ),
    array( 'zmdi-input-power' => 'input-power' ),
    array( 'zmdi-input-svideo' => 'input-svideo' ),
    array( 'zmdi-keyboard-hide' => 'keyboard-hide' ),
    array( 'zmdi-keyboard' => 'keyboard' ),
    array( 'zmdi-laptop-chromebook' => 'laptop-chromebook' ),
    array( 'zmdi-laptop-mac' => 'laptop-mac' ),
    array( 'zmdi-laptop' => 'laptop' ),
    array( 'zmdi-mic-off' => 'mic-off' ),
    array( 'zmdi-mic-outline' => 'mic-outline' ),
    array( 'zmdi-mic-setting' => 'mic-setting' ),
    array( 'zmdi-mic' => 'mic' ),
    array( 'zmdi-mouse' => 'mouse' ),
    array( 'zmdi-network-alert' => 'network-alert' ),
    array( 'zmdi-network-locked' => 'network-locked' ),
    array( 'zmdi-network-off' => 'network-off' ),
    array( 'zmdi-network-outline' => 'network-outline' ),
    array( 'zmdi-network-setting' => 'network-setting' ),
    array( 'zmdi-network' => 'network' ),
    array( 'zmdi-phone-bluetooth' => 'phone-bluetooth' ),
    array( 'zmdi-phone-end' => 'phone-end' ),
    array( 'zmdi-phone-forwarded' => 'phone-forwarded' ),
    array( 'zmdi-phone-in-talk' => 'phone-in-talk' ),
    array( 'zmdi-phone-locked' => 'phone-locked' ),
    array( 'zmdi-phone-missed' => 'phone-missed' ),
    array( 'zmdi-phone-msg' => 'phone-msg' ),
    array( 'zmdi-phone-paused' => 'phone-paused' ),
    array( 'zmdi-phone-ring' => 'phone-ring' ),
    array( 'zmdi-phone-setting' => 'phone-setting' ),
    array( 'zmdi-phone-sip' => 'phone-sip' ),
    array( 'zmdi-phone' => 'phone' ),
    array( 'zmdi-portable-wifi-changes' => 'portable-wifi-changes' ),
    array( 'zmdi-portable-wifi-off' => 'portable-wifi-off' ),
    array( 'zmdi-portable-wifi' => 'portable-wifi' ),
    array( 'zmdi-radio' => 'radio' ),
    array( 'zmdi-reader' => 'reader' ),
    array( 'zmdi-remote-control-alt' => 'remote-control-alt' ),
    array( 'zmdi-remote-control' => 'remote-control' ),
    array( 'zmdi-router' => 'router' ),
    array( 'zmdi-scanner' => 'scanner' ),
    array( 'zmdi-smartphone-android' => 'smartphone-android' ),
    array( 'zmdi-smartphone-download' => 'smartphone-download' ),
    array( 'zmdi-smartphone-erase' => 'smartphone-erase' ),
    array( 'zmdi-smartphone-info' => 'smartphone-info' ),
    array( 'zmdi-smartphone-iphone' => 'smartphone-iphone' ),
    array( 'zmdi-smartphone-landscape-lock' => 'smartphone-landscape-lock' ),
    array( 'zmdi-smartphone-landscape' => 'smartphone-landscape' ),
    array( 'zmdi-smartphone-lock' => 'smartphone-lock' ),
    array( 'zmdi-smartphone-portrait-lock' => 'smartphone-portrait-lock' ),
    array( 'zmdi-smartphone-ring' => 'smartphone-ring' ),
    array( 'zmdi-smartphone-setting' => 'smartphone-setting' ),
    array( 'zmdi-smartphone-setup' => 'smartphone-setup' ),
    array( 'zmdi-smartphone' => 'smartphone' ),
    array( 'zmdi-speaker' => 'speaker' ),
    array( 'zmdi-tablet-android' => 'tablet-android' ),
    array( 'zmdi-tablet-mac' => 'tablet-mac' ),
    array( 'zmdi-tablet' => 'tablet' ),
    array( 'zmdi-tv-alt-play' => 'tv-alt-play' ),
    array( 'zmdi-tv-list' => 'tv-list' ),
    array( 'zmdi-tv-play' => 'tv-play' ),
    array( 'zmdi-tv' => 'tv' ),
    array( 'zmdi-usb' => 'usb' ),
    array( 'zmdi-videocam-off' => 'videocam-off' ),
    array( 'zmdi-videocam-switch' => 'videocam-switch' ),
    array( 'zmdi-videocam' => 'videocam' ),
    array( 'zmdi-watch' => 'watch' ),
    array( 'zmdi-wifi-alt-2' => 'wifi-alt-2' ),
    array( 'zmdi-wifi-alt' => 'wifi-alt' ),
    array( 'zmdi-wifi-info' => 'wifi-info' ),
    array( 'zmdi-wifi-lock' => 'wifi-lock' ),
    array( 'zmdi-wifi-off' => 'wifi-off' ),
    array( 'zmdi-wifi-outline' => 'wifi-outline' ),
    array( 'zmdi-wifi' => 'wifi' ),
    array( 'zmdi-arrow-left-bottom' => 'arrow-left-bottom' ),
    array( 'zmdi-arrow-left' => 'arrow-left' ),
    array( 'zmdi-arrow-merge' => 'arrow-merge' ),
    array( 'zmdi-arrow-missed' => 'arrow-missed' ),
    array( 'zmdi-arrow-right-top' => 'arrow-right-top' ),
    array( 'zmdi-arrow-right' => 'arrow-right' ),
    array( 'zmdi-arrow-split' => 'arrow-split' ),
    array( 'zmdi-arrows' => 'arrows' ),
    array( 'zmdi-caret-down-circle' => 'caret-down-circle' ),
    array( 'zmdi-caret-down' => 'caret-down' ),
    array( 'zmdi-caret-left-circle' => 'caret-left-circle' ),
    array( 'zmdi-caret-left' => 'caret-left' ),
    array( 'zmdi-caret-right-circle' => 'caret-right-circle' ),
    array( 'zmdi-caret-right' => 'caret-right' ),
    array( 'zmdi-caret-up-circle' => 'caret-up-circle' ),
    array( 'zmdi-caret-up' => 'caret-up' ),
    array( 'zmdi-chevron-down' => 'chevron-down' ),
    array( 'zmdi-chevron-left' => 'chevron-left' ),
    array( 'zmdi-chevron-right' => 'chevron-right' ),
    array( 'zmdi-chevron-up' => 'chevron-up' ),
    array( 'zmdi-forward' => 'forward' ),
    array( 'zmdi-long-arrow-down' => 'long-arrow-down' ),
    array( 'zmdi-long-arrow-left' => 'long-arrow-left' ),
    array( 'zmdi-long-arrow-return' => 'long-arrow-return' ),
    array( 'zmdi-long-arrow-right' => 'long-arrow-right' ),
    array( 'zmdi-long-arrow-tab' => 'long-arrow-tab' ),
    array( 'zmdi-long-arrow-up' => 'long-arrow-up' ),
    array( 'zmdi-rotate-ccw' => 'rotate-ccw' ),
    array( 'zmdi-rotate-cw' => 'rotate-cw' ),
    array( 'zmdi-rotate-left' => 'rotate-left' ),
    array( 'zmdi-rotate-right' => 'rotate-right' ),
    array( 'zmdi-square-down' => 'square-down' ),
    array( 'zmdi-square-right' => 'square-right' ),
    array( 'zmdi-swap-alt' => 'swap-alt' ),
    array( 'zmdi-swap-vertical-circle' => 'swap-vertical-circle' ),
    array( 'zmdi-swap-vertical' => 'swap-vertical' ),
    array( 'zmdi-swap' => 'swap' ),
    array( 'zmdi-trending-down' => 'trending-down' ),
    array( 'zmdi-trending-flat' => 'trending-flat' ),
    array( 'zmdi-trending-up' => 'trending-up' ),
    array( 'zmdi-unfold-less' => 'unfold-less' ),
    array( 'zmdi-unfold-more' => 'unfold-more' ),
    array( 'zmdi-apps' => 'apps' ),
    array( 'zmdi-grid-off' => 'grid-off' ),
    array( 'zmdi-grid' => 'grid' ),
    array( 'zmdi-view-agenda' => 'view-agenda' ),
    array( 'zmdi-view-array' => 'view-array' ),
    array( 'zmdi-view-carousel' => 'view-carousel' ),
    array( 'zmdi-view-column' => 'view-column' ),
    array( 'zmdi-view-comfy' => 'view-comfy' ),
    array( 'zmdi-view-compact' => 'view-compact' ),
    array( 'zmdi-view-dashboard' => 'view-dashboard' ),
    array( 'zmdi-view-day' => 'view-day' ),
    array( 'zmdi-view-headline' => 'view-headline' ),
    array( 'zmdi-view-list-alt' => 'view-list-alt' ),
    array( 'zmdi-view-list' => 'view-list' ),
    array( 'zmdi-view-module' => 'view-module' ),
    array( 'zmdi-view-quilt' => 'view-quilt' ),
    array( 'zmdi-view-stream' => 'view-stream' ),
    array( 'zmdi-view-subtitles' => 'view-subtitles' ),
    array( 'zmdi-view-toc' => 'view-toc' ),
    array( 'zmdi-view-web' => 'view-web' ),
    array( 'zmdi-view-week' => 'view-week' ),
    array( 'zmdi-widgets' => 'widgets' ),
    array( 'zmdi-alarm-check' => 'alarm-check' ),
    array( 'zmdi-alarm-off' => 'alarm-off' ),
    array( 'zmdi-alarm-plus' => 'alarm-plus' ),
    array( 'zmdi-alarm-snooze' => 'alarm-snooze' ),
    array( 'zmdi-alarm' => 'alarm' ),
    array( 'zmdi-calendar-alt' => 'calendar-alt' ),
    array( 'zmdi-calendar-check' => 'calendar-check' ),
    array( 'zmdi-calendar-close' => 'calendar-close' ),
    array( 'zmdi-calendar-note' => 'calendar-note' ),
    array( 'zmdi-calendar' => 'calendar' ),
    array( 'zmdi-time-countdown' => 'time-countdown' ),
    array( 'zmdi-time-interval' => 'time-interval' ),
    array( 'zmdi-time-restore-setting' => 'time-restore-setting' ),
    array( 'zmdi-time-restore' => 'time-restore' ),
    array( 'zmdi-time' => 'time' ),
    array( 'zmdi-timer-off' => 'timer-off' ),
    array( 'zmdi-timer' => 'timer' ),
    array( 'zmdi-android-alt' => 'android-alt' ),
    array( 'zmdi-android' => 'android' ),
    array( 'zmdi-apple' => 'apple' ),
    array( 'zmdi-behance' => 'behance' ),
    array( 'zmdi-codepen' => 'codepen' ),
    array( 'zmdi-dribbble' => 'dribbble' ),
    array( 'zmdi-dropbox' => 'dropbox' ),
    array( 'zmdi-evernote' => 'evernote' ),
    array( 'zmdi-facebook-box' => 'facebook-box' ),
    array( 'zmdi-facebook' => 'facebook' ),
    array( 'zmdi-github-box' => 'github-box' ),
    array( 'zmdi-github' => 'github' ),
    array( 'zmdi-google-drive' => 'google-drive' ),
    array( 'zmdi-google-earth' => 'google-earth' ),
    array( 'zmdi-google-glass' => 'google-glass' ),
    array( 'zmdi-google-maps' => 'google-maps' ),
    array( 'zmdi-google-pages' => 'google-pages' ),
    array( 'zmdi-google-play' => 'google-play' ),
    array( 'zmdi-google-plus-box' => 'google-plus-box' ),
    array( 'zmdi-google-plus' => 'google-plus' ),
    array( 'zmdi-google' => 'google' ),
    array( 'zmdi-instagram' => 'instagram' ),
    array( 'zmdi-language-css3' => 'language-css3' ),
    array( 'zmdi-language-html5' => 'language-html5' ),
    array( 'zmdi-language-javascript' => 'language-javascript' ),
    array( 'zmdi-language-python-alt' => 'language-python-alt' ),
    array( 'zmdi-language-python' => 'language-python' ),
    array( 'zmdi-lastfm' => 'lastfm' ),
    array( 'zmdi-linkedin-box' => 'linkedin-box' ),
    array( 'zmdi-paypal' => 'paypal' ),
    array( 'zmdi-pinterest-box' => 'pinterest-box' ),
    array( 'zmdi-pocket' => 'pocket' ),
    array( 'zmdi-polymer' => 'polymer' ),
    array( 'zmdi-share' => 'share' ),
    array( 'zmdi-stackoverflow' => 'stackoverflow' ),
    array( 'zmdi-steam-square' => 'steam-square' ),
    array( 'zmdi-steam' => 'steam' ),
    array( 'zmdi-twitter-box' => 'twitter-box' ),
    array( 'zmdi-twitter' => 'twitter' ),
    array( 'zmdi-vk' => 'vk' ),
    array( 'zmdi-wikipedia' => 'wikipedia' ),
    array( 'zmdi-windows' => 'windows' ),
    array( 'zmdi-aspect-ratio-alt' => 'aspect-ratio-alt' ),
    array( 'zmdi-aspect-ratio' => 'aspect-ratio' ),
    array( 'zmdi-blur-circular' => 'blur-circular' ),
    array( 'zmdi-blur-linear' => 'blur-linear' ),
    array( 'zmdi-blur-off' => 'blur-off' ),
    array( 'zmdi-blur' => 'blur' ),
    array( 'zmdi-brightness-2' => 'brightness-2' ),
    array( 'zmdi-brightness-3' => 'brightness-3' ),
    array( 'zmdi-brightness-4' => 'brightness-4' ),
    array( 'zmdi-brightness-5' => 'brightness-5' ),
    array( 'zmdi-brightness-6' => 'brightness-6' ),
    array( 'zmdi-brightness-7' => 'brightness-7' ),
    array( 'zmdi-brightness-auto' => 'brightness-auto' ),
    array( 'zmdi-brightness-setting' => 'brightness-setting' ),
    array( 'zmdi-broken-image' => 'broken-image' ),
    array( 'zmdi-center-focus-strong' => 'center-focus-strong' ),
    array( 'zmdi-center-focus-weak' => 'center-focus-weak' ),
    array( 'zmdi-compare' => 'compare' ),
    array( 'zmdi-crop-16-9' => 'crop-16-9' ),
    array( 'zmdi-crop-3-2' => 'crop-3-2' ),
    array( 'zmdi-crop-5-4' => 'crop-5-4' ),
    array( 'zmdi-crop-7-5' => 'crop-7-5' ),
    array( 'zmdi-crop-din' => 'crop-din' ),
    array( 'zmdi-crop-free' => 'crop-free' ),
    array( 'zmdi-crop-landscape' => 'crop-landscape' ),
    array( 'zmdi-crop-portrait' => 'crop-portrait' ),
    array( 'zmdi-crop-square' => 'crop-square' ),
    array( 'zmdi-exposure-alt' => 'exposure-alt' ),
    array( 'zmdi-exposure' => 'exposure' ),
    array( 'zmdi-filter-b-and-w' => 'filter-b-and-w' ),
    array( 'zmdi-filter-center-focus' => 'filter-center-focus' ),
    array( 'zmdi-filter-frames' => 'filter-frames' ),
    array( 'zmdi-filter-tilt-shift' => 'filter-tilt-shift' ),
    array( 'zmdi-gradient' => 'gradient' ),
    array( 'zmdi-grain' => 'grain' ),
    array( 'zmdi-graphic-eq' => 'graphic-eq' ),
    array( 'zmdi-hdr-off' => 'hdr-off' ),
    array( 'zmdi-hdr-strong' => 'hdr-strong' ),
    array( 'zmdi-hdr-weak' => 'hdr-weak' ),
    array( 'zmdi-hdr' => 'hdr' ),
    array( 'zmdi-iridescent' => 'iridescent' ),
    array( 'zmdi-leak-off' => 'leak-off' ),
    array( 'zmdi-leak' => 'leak' ),
    array( 'zmdi-looks' => 'looks' ),
    array( 'zmdi-loupe' => 'loupe' ),
    array( 'zmdi-panorama-horizontal' => 'panorama-horizontal' ),
    array( 'zmdi-panorama-vertical' => 'panorama-vertical' ),
    array( 'zmdi-panorama-wide-angle' => 'panorama-wide-angle' ),
    array( 'zmdi-photo-size-select-large' => 'photo-size-select-large' ),
    array( 'zmdi-photo-size-select-small' => 'photo-size-select-small' ),
    array( 'zmdi-picture-in-picture' => 'picture-in-picture' ),
    array( 'zmdi-slideshow' => 'slideshow' ),
    array( 'zmdi-texture' => 'texture' ),
    array( 'zmdi-tonality' => 'tonality' ),
    array( 'zmdi-vignette' => 'vignette' ),
    array( 'zmdi-wb-auto' => 'wb-auto' ),
    array( 'zmdi-eject-alt' => 'eject-alt' ),
    array( 'zmdi-eject' => 'eject' ),
    array( 'zmdi-equalizer' => 'equalizer' ),
    array( 'zmdi-fast-forward' => 'fast-forward' ),
    array( 'zmdi-fast-rewind' => 'fast-rewind' ),
    array( 'zmdi-forward-10' => 'forward-10' ),
    array( 'zmdi-forward-30' => 'forward-30' ),
    array( 'zmdi-forward-5' => 'forward-5' ),
    array( 'zmdi-hearing' => 'hearing' ),
    array( 'zmdi-pause-circle-outline' => 'pause-circle-outline' ),
    array( 'zmdi-pause-circle' => 'pause-circle' ),
    array( 'zmdi-pause' => 'pause' ),
    array( 'zmdi-play-circle-outline' => 'play-circle-outline' ),
    array( 'zmdi-play-circle' => 'play-circle' ),
    array( 'zmdi-play' => 'play' ),
    array( 'zmdi-playlist-audio' => 'playlist-audio' ),
    array( 'zmdi-playlist-plus' => 'playlist-plus' ),
    array( 'zmdi-repeat-one' => 'repeat-one' ),
    array( 'zmdi-repeat' => 'repeat' ),
    array( 'zmdi-replay-10' => 'replay-10' ),
    array( 'zmdi-replay-30' => 'replay-30' ),
    array( 'zmdi-replay-5' => 'replay-5' ),
    array( 'zmdi-replay' => 'replay' ),
    array( 'zmdi-shuffle' => 'shuffle' ),
    array( 'zmdi-skip-next' => 'skip-next' ),
    array( 'zmdi-skip-previous' => 'skip-previous' ),
    array( 'zmdi-stop' => 'stop' ),
    array( 'zmdi-surround-sound' => 'surround-sound' ),
    array( 'zmdi-tune' => 'tune' ),
    array( 'zmdi-volume-down' => 'volume-down' ),
    array( 'zmdi-volume-mute' => 'volume-mute' ),
    array( 'zmdi-volume-off' => 'volume-off' ),
    array( 'zmdi-volume-up' => 'volume-up' ),
    array( 'zmdi-n-1-square' => 'n-1-square' ),
    array( 'zmdi-n-2-square' => 'n-2-square' ),
    array( 'zmdi-n-3-square' => 'n-3-square' ),
    array( 'zmdi-n-4-square' => 'n-4-square' ),
    array( 'zmdi-n-5-square' => 'n-5-square' ),
    array( 'zmdi-n-6-square' => 'n-6-square' ),
    array( 'zmdi-neg-1' => 'neg-1' ),
    array( 'zmdi-neg-2' => 'neg-2' ),
    array( 'zmdi-plus-1' => 'plus-1' ),
    array( 'zmdi-plus-2' => 'plus-2' ),
    array( 'zmdi-sec-10' => 'sec-10' ),
    array( 'zmdi-sec-3' => 'sec-3' ),
    array( 'zmdi-zero' => 'zero' ),
    array( 'zmdi-airline-seat-flat-angled' => 'airline-seat-flat-angled' ),
    array( 'zmdi-airline-seat-flat' => 'airline-seat-flat' ),
    array( 'zmdi-airline-seat-individual-suite' => 'airline-seat-individual-suite' ),
    array( 'zmdi-airline-seat-legroom-extra' => 'airline-seat-legroom-extra' ),
    array( 'zmdi-airline-seat-legroom-normal' => 'airline-seat-legroom-normal' ),
    array( 'zmdi-airline-seat-legroom-reduced' => 'airline-seat-legroom-reduced' ),
    array( 'zmdi-airline-seat-recline-extra' => 'airline-seat-recline-extra' ),
    array( 'zmdi-airline-seat-recline-normal' => 'airline-seat-recline-normal' ),
    array( 'zmdi-airplay' => 'airplay' ),
    array( 'zmdi-closed-caption' => 'closed-caption' ),
    array( 'zmdi-confirmation-number' => 'confirmation-number' ),
    array( 'zmdi-developer-board' => 'developer-board' ),
    array( 'zmdi-disc-full' => 'disc-full' ),
    array( 'zmdi-explicit' => 'explicit' ),
    array( 'zmdi-flight-land' => 'flight-land' ),
    array( 'zmdi-flight-takeoff' => 'flight-takeoff' ),
    array( 'zmdi-flip-to-back' => 'flip-to-back' ),
    array( 'zmdi-flip-to-front' => 'flip-to-front' ),
    array( 'zmdi-group-work' => 'group-work' ),
    array( 'zmdi-hd' => 'hd' ),
    array( 'zmdi-hq' => 'hq' ),
    array( 'zmdi-markunread-mailbox' => 'markunread-mailbox' ),
    array( 'zmdi-memory' => 'memory' ),
    array( 'zmdi-nfc' => 'nfc' ),
    array( 'zmdi-play-for-work' => 'play-for-work' ),
    array( 'zmdi-power-input' => 'power-input' ),
    array( 'zmdi-present-to-all' => 'present-to-all' ),
    array( 'zmdi-satellite' => 'satellite' ),
    array( 'zmdi-tap-and-play' => 'tap-and-play' ),
    array( 'zmdi-vibration' => 'vibration' ),
    array( 'zmdi-voicemail' => 'voicemail' ),
    array( 'zmdi-group' => 'group' ),
    array( 'zmdi-rss' => 'rss' ),
    array( 'zmdi-shape' => 'shape' ),
    array( 'zmdi-spinner' => 'spinner' ),
    array( 'zmdi-ungroup' => 'ungroup' ),
    array( 'zmdi-500px' => '500px' ),
    array( 'zmdi-8tracks' => '8tracks' ),
    array( 'zmdi-amazon' => 'amazon' ),
    array( 'zmdi-blogger' => 'blogger' ),
    array( 'zmdi-delicious' => 'delicious' ),
    array( 'zmdi-disqus' => 'disqus' ),
    array( 'zmdi-flattr' => 'flattr' ),
    array( 'zmdi-flickr' => 'flickr' ),
    array( 'zmdi-github-alt' => 'github-alt' ),
    array( 'zmdi-google-old' => 'google-old' ),
    array( 'zmdi-linkedin' => 'linkedin' ),
    array( 'zmdi-odnoklassniki' => 'odnoklassniki' ),
    array( 'zmdi-outlook' => 'outlook' ),
    array( 'zmdi-paypal-alt' => 'paypal-alt' ),
    array( 'zmdi-pinterest' => 'pinterest' ),
    array( 'zmdi-playstation' => 'playstation' ),
    array( 'zmdi-reddit' => 'reddit' ),
    array( 'zmdi-skype' => 'skype' ),
    array( 'zmdi-slideshare' => 'slideshare' ),
    array( 'zmdi-soundcloud' => 'soundcloud' ),
    array( 'zmdi-tumblr' => 'tumblr' ),
    array( 'zmdi-twitch' => 'twitch' ),
    array( 'zmdi-vimeo' => 'vimeo' ),
    array( 'zmdi-whatsapp' => 'whatsapp' ),
    array( 'zmdi-xbox' => 'xbox' ),
    array( 'zmdi-yahoo' => 'yahoo' ),
    array( 'zmdi-youtube-play' => 'youtube-play' ),
    array( 'zmdi-youtube' => 'youtube' ),
    array( 'zmdi-import-export' => 'import-export' ),
    array( 'zmdi-swap-vertical-' => 'swap-vertical-' ),
    array( 'zmdi-airplanemode-inactive' => 'airplanemode-inactive' ),
    array( 'zmdi-airplanemode-active' => 'airplanemode-active' ),
    array( 'zmdi-rate-review' => 'rate-review' ),
    array( 'zmdi-comment-sign' => 'comment-sign' ),
    array( 'zmdi-network-warning' => 'network-warning' ),
    array( 'zmdi-shopping-cart-add' => 'shopping-cart-add' ),
    array( 'zmdi-file-add' => 'file-add' ),
    array( 'zmdi-network-wifi-scan' => 'network-wifi-scan' ),
    array( 'zmdi-collection-add' => 'collection-add' ),
    array( 'zmdi-format-playlist-add' => 'format-playlist-add' ),
    array( 'zmdi-format-queue-music' => 'format-queue-music' ),
    array( 'zmdi-plus-box' => 'plus-box' ),
    array( 'zmdi-tag-backspace' => 'tag-backspace' ),
    array( 'zmdi-alarm-add' => 'alarm-add' ),
    array( 'zmdi-battery-charging' => 'battery-charging' ),
    array( 'zmdi-daydream-setting' => 'daydream-setting' ),
    array( 'zmdi-more-horiz' => 'more-horiz' ),
    array( 'zmdi-book-photo' => 'book-photo' ),
    array( 'zmdi-incandescent' => 'incandescent' ),
    array( 'zmdi-wb-iridescent' => 'wb-iridescent' ),
    array( 'zmdi-calendar-remove' => 'calendar-remove' ),
    array( 'zmdi-refresh-sync-disabled' => 'refresh-sync-disabled' ),
    array( 'zmdi-refresh-sync-problem' => 'refresh-sync-problem' ),
    array( 'zmdi-crop-original' => 'crop-original' ),
    array( 'zmdi-power-off' => 'power-off' ),
    array( 'zmdi-power-off-setting' => 'power-off-setting' ),
    array( 'zmdi-leak-remove' => 'leak-remove' ),
    array( 'zmdi-star-border' => 'star-border' ),
    array( 'zmdi-brightness-low' => 'brightness-low' ),
    array( 'zmdi-brightness-medium' => 'brightness-medium' ),
    array( 'zmdi-brightness-high' => 'brightness-high' ),
    array( 'zmdi-smartphone-portrait' => 'smartphone-portrait' ),
    array( 'zmdi-live-tv' => 'live-tv' ),
    array( 'zmdi-format-textdirection-l-to-r' => 'format-textdirection-l-to-r' ),
    array( 'zmdi-format-textdirection-r-to-l' => 'format-textdirection-r-to-l' ),
    array( 'zmdi-arrow-back' => 'arrow-back' ),
    array( 'zmdi-arrow-forward' => 'arrow-forward' ),
    array( 'zmdi-arrow-in' => 'arrow-in' ),
    array( 'zmdi-arrow-out' => 'arrow-out' ),
    array( 'zmdi-rotate-90-degrees-ccw' => 'rotate-90-degrees-ccw' ),
    array( 'zmdi-adb' => 'adb' ),
    array( 'zmdi-network-wifi' => 'network-wifi' ),
    array( 'zmdi-network-wifi-alt' => 'network-wifi-alt' ),
    array( 'zmdi-network-wifi-lock' => 'network-wifi-lock' ),
    array( 'zmdi-network-wifi-off' => 'network-wifi-off' ),
    array( 'zmdi-network-wifi-outline' => 'network-wifi-outline' ),
    array( 'zmdi-network-wifi-info' => 'network-wifi-info' ),
    array( 'zmdi-layers-clear' => 'layers-clear' ),
    array( 'zmdi-colorize' => 'colorize' ),
    array( 'zmdi-format-paint' => 'format-paint' ),
    array( 'zmdi-format-quote' => 'format-quote' ),
    array( 'zmdi-camera-monochrome-photos' => 'camera-monochrome-photos' ),
    array( 'zmdi-sort-by-alpha' => 'sort-by-alpha' ),
    array( 'zmdi-folder-shared' => 'folder-shared' ),
    array( 'zmdi-folder-special' => 'folder-special' ),
    array( 'zmdi-comment-dots' => 'comment-dots' ),
    array( 'zmdi-reorder' => 'reorder' ),
    array( 'zmdi-dehaze' => 'dehaze' ),
    array( 'zmdi-sort' => 'sort' ),
    array( 'zmdi-pages' => 'pages' ),
    array( 'zmdi-stack-overflow' => 'stack-overflow' ),
    array( 'zmdi-calendar-account' => 'calendar-account' ),
    array( 'zmdi-paste' => 'paste' ),
    array( 'zmdi-cut' => 'cut' ),
    array( 'zmdi-save' => 'save' ),
    array( 'zmdi-smartphone-code' => 'smartphone-code' ),
    array( 'zmdi-directions-bike' => 'directions-bike' ),
    array( 'zmdi-directions-boat' => 'directions-boat' ),
    array( 'zmdi-directions-bus' => 'directions-bus' ),
    array( 'zmdi-directions-car' => 'directions-car' ),
    array( 'zmdi-directions-railway' => 'directions-railway' ),
    array( 'zmdi-directions-run' => 'directions-run' ),
    array( 'zmdi-directions-subway' => 'directions-subway' ),
    array( 'zmdi-directions-walk' => 'directions-walk' ),
    array( 'zmdi-local-hotel' => 'local-hotel' ),
    array( 'zmdi-local-activity' => 'local-activity' ),
    array( 'zmdi-local-play' => 'local-play' ),
    array( 'zmdi-local-airport' => 'local-airport' ),
    array( 'zmdi-local-atm' => 'local-atm' ),
    array( 'zmdi-local-bar' => 'local-bar' ),
    array( 'zmdi-local-cafe' => 'local-cafe' ),
    array( 'zmdi-local-car-wash' => 'local-car-wash' ),
    array( 'zmdi-local-convenience-store' => 'local-convenience-store' ),
    array( 'zmdi-local-dining' => 'local-dining' ),
    array( 'zmdi-local-drink' => 'local-drink' ),
    array( 'zmdi-local-florist' => 'local-florist' ),
    array( 'zmdi-local-gas-station' => 'local-gas-station' ),
    array( 'zmdi-local-grocery-store' => 'local-grocery-store' ),
    array( 'zmdi-local-hospital' => 'local-hospital' ),
    array( 'zmdi-local-laundry-service' => 'local-laundry-service' ),
    array( 'zmdi-local-library' => 'local-library' ),
    array( 'zmdi-local-mall' => 'local-mall' ),
    array( 'zmdi-local-movies' => 'local-movies' ),
    array( 'zmdi-local-offer' => 'local-offer' ),
    array( 'zmdi-local-parking' => 'local-parking' ),
    array( 'zmdi-local-parking' => 'local-parking' ),
    array( 'zmdi-local-pharmacy' => 'local-pharmacy' ),
    array( 'zmdi-local-phone' => 'local-phone' ),
    array( 'zmdi-local-pizza' => 'local-pizza' ),
    array( 'zmdi-local-post-office' => 'local-post-office' ),
    array( 'zmdi-local-printshop' => 'local-printshop' ),
    array( 'zmdi-local-see' => 'local-see' ),
    array( 'zmdi-local-shipping' => 'local-shipping' ),
    array( 'zmdi-local-store' => 'local-store' ),
    array( 'zmdi-local-taxi' => 'local-taxi' ),
    array( 'zmdi-local-wc' => 'local-wc' ),
    array( 'zmdi-my-location' => 'my-location' ),
    array( 'zmdi-directions' => 'directions' ),
	);

	return array_merge( $icons, $material_icons );
}
